<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package pagli
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<?php if(is_page_template('tpl-home.php') && is_front_page()) : ?>
		<?php do_action( 'pagli_home_header' ); ?>
	<?php else : ?>
		<?php do_action( 'pagli_inner_header' ); ?>
	<?php endif; ?>

	<div id="content" class="site-content pagli-container">
