<?php
/**
 * pagli functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package pagli
 */

if ( ! function_exists( 'pagli_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function pagli_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on pagli, use a find and replace
	 * to change 'pagli' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'pagli', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'menu-1' => esc_html__( 'Primary', 'pagli' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'pagli_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	/** Support For Custom Logo **/
	add_theme_support( 'custom-logo' );

	/** Support For WooCommerce **/
	add_theme_support( 'woocommerce' );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );
}
endif;
add_action( 'after_setup_theme', 'pagli_setup' );

/** Add Image Sizes **/
add_image_size( 'pagli-portfolio-thumb', 600, 400, true );

/**
 * Registers an editor stylesheet for the theme.
 */
function pagli_theme_add_editor_styles() {
    add_editor_style( 'custom-editor-style.css' );
}
add_action( 'admin_init', 'pagli_theme_add_editor_styles' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function pagli_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'pagli_content_width', 640 );
}
add_action( 'after_setup_theme', 'pagli_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function pagli_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'pagli' ),
		'id'            => 'pagli-right-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'pagli' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Woo Sidebar', 'pagli' ),
		'id'            => 'pagli-woo-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'pagli' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'pagli_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function pagli_scripts() {

	$font_args = array(
        'family' => 'Raleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i',
    );

    wp_enqueue_style('pagli-google-fonts', add_query_arg($font_args, "//fonts.googleapis.com/css"));

	wp_enqueue_style( 'pagli-style', get_stylesheet_uri() );

	wp_enqueue_style('pagli-responsive', get_template_directory_uri() . '/css/responsive.css', false);

	wp_enqueue_style( 'font-awesome', get_template_directory_uri().'/assets/faw/css/font-awesome.min.css' );

	wp_enqueue_style( 'jquery-fancybox', get_template_directory_uri().'/assets/fancybox/jquery.fancybox.css' );

	wp_enqueue_script( 'pagli-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );

	wp_enqueue_script( 'pagli-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	wp_enqueue_script( 'isotope-pkgd', get_template_directory_uri() . '/js/isotope.pkgd.js', array(), '20151215', true );

	wp_enqueue_script( 'jquery-fancybox', get_template_directory_uri() . '/js/jquery.fancybox.js', array(), '20151215', true );	

	wp_enqueue_script( 'pagli-custom', get_template_directory_uri() . '/js/custom.js', array('imagesloaded', 'isotope-pkgd', 'jquery-fancybox'), '20151215', true );
}
add_action( 'wp_enqueue_scripts', 'pagli_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Load Custom Hook Files
 */
require get_template_directory() . '/pagli/hooks.php';

/**
 * Load Custom Hook Files
 */
require get_template_directory() . '/pagli/woo.php';

/**
 * TGM Plugin Suggesstions
 */
require get_template_directory() . '/inc/pagli-tgm-suggest.php';

/**
 * Load Custom Pagli Function File
 */
require get_template_directory() . '/pagli/pagli-functions.php';