<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package pagli
 */

?>

	</div><!-- #content -->

	<footer id="colophon" class="site-footer" role="contentinfo">

		<!-- Footer Widgets -->
		<div class="top-footer clearfix">
			<div class="pagli-container">
				<?php if(is_active_sidebar('pagli-footer-1')) : ?>
					<?php dynamic_sidebar('pagli-footer-1'); ?>
				<?php endif; ?>

				<?php if(is_active_sidebar('pagli-footer-2')) : ?>
					<?php dynamic_sidebar('pagli-footer-2'); ?>
				<?php endif; ?>

				<?php if(is_active_sidebar('pagli-footer-3')) : ?>
					<?php dynamic_sidebar('pagli-footer-3'); ?>
				<?php endif; ?>
			</div>
		</div>
		<div class="bottom-footer clearfix">
			<div class="pagli-container">
				<div class="social-icons">
					<?php
						$pagli_fb_link = get_theme_mod('pagli_fb_link', '');
						$pagli_twitter_link = get_theme_mod('pagli_twitter_link', '');
						$pagli_gplus_link = get_theme_mod('pagli_gplus_link', '');
						$pagli_linkedin_link = get_theme_mod('pagli_linkedin_link', '');
						$pagli_youtube_link = get_theme_mod('pagli_youtube_link', '');
					?>

					<?php if(!empty($pagli_fb_link)) : ?>
						<a href="<?php echo esc_url($pagli_fb_link); ?>"><i class="fa fa-facebook"></i></a>
					<?php endif; ?>

					<?php if(!empty($pagli_twitter_link)) : ?>
						<a href="<?php echo esc_url($pagli_twitter_link); ?>"><i class="fa fa-twitter"></i></a>
					<?php endif; ?>

					<?php if(!empty($pagli_gplus_link)) : ?>
						<a href="<?php echo esc_url($pagli_gplus_link); ?>"><i class="fa fa-google-plus"></i></a>
					<?php endif; ?>

					<?php if(!empty($pagli_linkedin_link)) : ?>
						<a href="<?php echo esc_url($pagli_linkedin_link); ?>"><i class="fa fa-linkedin"></i></a>
					<?php endif; ?>

					<?php if(!empty($pagli_youtube_link)) : ?>
						<a href="<?php echo esc_url($pagli_youtube_link); ?>"><i class="fa fa-youtube"></i></a>
					<?php endif; ?>
				</div>

				<div class="site-info">
					<?php printf( esc_html__( '&copy; 2017 %1$s Designed and Developed by %2$s', 'pagli' ), 'pagli', '<a href="http://www.paglithemes.com">PagliThemes</a>' ); ?>
				</div><!-- .site-info -->
			</div>
		</div>
	</footer><!-- #colophon -->

	<a id="return-to-top"><i class="fa fa-angle-up"></i></a>

</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>