<?php // phpcs:ignore
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Template for theme info page.
 *
 */

?>
<div id="welcome-panels" class="welcome-panel outdoor-restaurant-hero ">
	<div class="welcome-panel-content outdoor-restaurant-hero">
		<div class="welcome-panel-header outdoor-restaurant-hero">
			<h2>
				<?php esc_html_e( 'Welcome to Outdoor Restaurant', 'outdoor-restaurant' ); ?>
			</h2>
			<p>
				<?php
				esc_html_e( 'Outdoor Restaurant is designed to give your website a bold, elegant, and professional look—ready to launch in just a few clicks.', 'outdoor-restaurant' );
				?>
			</p>




		<div class="not-link">
			<a href="https://www.thealphablocks.com/themes/outdoor-restaurant-wordpress-theme/" target="_blank" rel="noopener noreferrer nofollow" class="outdoor-restaurant-btn outdoor-restaurant-btn-default button button-secodary button-hero ddd" >
				<?php esc_html_e( 'Buy Now', 'outdoor-restaurant' ); ?>
			</a>
			<a href="https://www.thealphablocks.com/themes/wordpress-theme-bundle/" target="_blank" rel="noopener noreferrer nofollow" class="outdoor-restaurant-btn outdoor-restaurant-btn-default button button-secodary button-hero bbb" target="_blank">
				<?php esc_html_e( 'Get All Themes', 'outdoor-restaurant' ); ?>
			</a>
			<a href="https://www.thealphablocks.com/demos/outdoor-restaurant-pro/" target="_blank" rel="noopener noreferrer nofollow" class="outdoor-restaurant-btn outdoor-restaurant-btn-default button button-secodary button-hero ccc" target="_blank">
				<?php esc_html_e( 'Live Demo', 'outdoor-restaurant' ); ?>
			</a>
			<a href="https://www.thealphablocks.com/docs/outdoor-restaurant-free/" target="_blank" rel="noopener noreferrer nofollow" class="outdoor-restaurant-gsn-btn  outdoor-restaurant-btn-outline button button-primary button-hero ghf outdoor-restaurant-install-plugins"  target="_blank">
				<?php esc_html_e( 'Documentation', 'outdoor-restaurant' ); ?>
			</a>
		</div>
		</div>

					<div class="bundle-img-wrap">
			            <img src="<?php echo esc_url( get_template_directory_uri() . '/images/main-banner.png' ); ?>">
			        </div>
		
	</div>
</div>

<div class="outdoor-restaurant-main">
	<div class="row margin outdoor-restaurant-main-wrp">
		<div class="col-lg-3">
			<div class="outdoor-restaurant-main-sidebar">
				<div class="theme-screenshot-box">
					<div class="outdoor-restaurant-card-header abc">
						<h4 class="outdoor-restaurant-card-header-ttl">
							<?php esc_html_e( 'Premium Theme', 'outdoor-restaurant' ); ?>
						</h4>
					</div>	
					<div class="screenshot-container" id="screenshotContainer">
						<img id="scrollImage" src="<?php echo esc_url( get_template_directory_uri() . '/images/screenshort-image.png' ); ?>">
					</div>
				</div>
			</div>
		</div>

		<div class="col-lg-6 alpha-right">
			<div class="outdoor-restaurant-main-cont">
				<div class="row features">
					<div class="col-md-6 col-xl-3">
						<div class="outdoor-restaurant-card">
							<div class="outdoor-restaurant-card-header">
								<span class="dashicons dashicons-media-document"></span>
								<h4 class="outdoor-restaurant-card-header-mmm">
									<?php esc_html_e( 'Responsive Design', 'outdoor-restaurant' ); ?>
								</h4>
							</div>
							<div class="outdoor-restaurant-card-body">
								<p class="margin">
									<?php esc_html_e( 'Your website adapts to all screen sizes for seamless viewing experience.', 'outdoor-restaurant' ); ?>
								</p>
								
							</div>
						</div>
					</div>
					<div class="col-md-6 col-xl-3">
						<div class="outdoor-restaurant-card">
							<div class="outdoor-restaurant-card-header">
								<span class="dashicons dashicons-groups"></span>
									<h4 class="outdoor-restaurant-card-header-mmm">
									<?php esc_html_e( 'Demo Import', 'outdoor-restaurant' ); ?>
								</h4>
							</div>
							<div class="outdoor-restaurant-card-body">
								<p class="margin">
									<?php esc_html_e( 'Our themes has one-click demo import making it easier to launch website.', 'outdoor-restaurant' ); ?>
								</p>
								
							</div>
						</div>
					</div>
					<div class="col-md-6 col-xl-3">
						<div class="outdoor-restaurant-card">
							<div class="outdoor-restaurant-card-header">
								<span class="dashicons dashicons-backup"></span>
									<h4 class="outdoor-restaurant-card-header-mmm">
									<?php esc_html_e( 'Cross Browser Compatible
									', 'outdoor-restaurant' ); ?>
								</h4>
							</div>
							<div class="outdoor-restaurant-card-body">
								<p class="margin">
									<?php esc_html_e( 'Runs smoothly across all major browsers for consistent site experience.', 'outdoor-restaurant' ); ?>
								</p>
								
							</div>
						</div>
					</div>
					<div class="col-md-6 col-xl-3">
						<div class="outdoor-restaurant-card">
							<div class="outdoor-restaurant-card-header">
								<span class="dashicons dashicons-video-alt3"></span>
									<h4 class="outdoor-restaurant-card-header-mmm">
									<?php esc_html_e( 'Easy Customization', 'outdoor-restaurant' ); ?>
								</h4>
							</div>
							<div class="outdoor-restaurant-card-body">
								<p class="margin">
									<?php esc_html_e( 'Quickly personalize fonts, colors, and layouts using simple customization panel.', 'outdoor-restaurant' ); ?>
								</p>
								
							</div>
						</div>
					</div>
				</div>
				
					<div class="<?php echo esc_attr( $quick_links_col ); ?>">
						<div class="outdoor-restaurant-card">
							<div class="outdoor-restaurant-card-header justify-content ">
								<span class="dashicons dashicons-admin-links"></span>
								<h4 class="outdoor-restaurant-card-header-ttl">
									<?php esc_html_e( 'Quick Links', 'outdoor-restaurant' ); ?>
								</h4>
							</div>
							<div class="outdoor-restaurant-card-body">
								<div class="outdoor-restaurant-card-btn-grp rrr">
									<a class="outdoor-restaurant-btn outdoor-restaurant-btn-primary-outline button button-hero btn-col" href="<?php echo esc_url( admin_url( 'site-editor.php?categoryId=header&postType=wp_template_part' ) ); ?>" target="_blank">
										<?php esc_html_e( 'Edit Header', 'outdoor-restaurant' ); ?>
									</a>
									<a class="outdoor-restaurant-btn outdoor-restaurant-btn-primary-outline button button-hero btn-col" href="<?php echo esc_url( admin_url( 'site-editor.php?postType=wp_template_part&postId=' . OUTDOOR_RESTAURANT_THEME_NAME . '%2F%2Ffooter&canvas=edit' ) ); ?>" target="_blank">
										<?php esc_html_e( 'Edit Footer', 'outdoor-restaurant' ); ?>
									</a>
									<a class="outdoor-restaurant-btn outdoor-restaurant-btn-primary-outline button button-hero btn-col" href="<?php echo esc_url( admin_url( 'site-editor.php?postType=wp_template_part&postId=' . OUTDOOR_RESTAURANT_THEME_NAME . '%2F%2Fsidebar&canvas=edit' ) ); ?>" target="_blank">
										<?php esc_html_e( 'Edit Sidebar', 'outdoor-restaurant' ); ?>
									</a>
									<a class="outdoor-restaurant-btn outdoor-restaurant-btn-primary-outline button button-hero btn-col" 
										href="<?php echo esc_url( admin_url( 'site-editor.php?postType=wp_template&postId=' . OUTDOOR_RESTAURANT_THEME_NAME . '%2F%2Findex&canvas=edit' ) ); ?>" 
										target="_blank">
										<?php esc_html_e( 'Edit Blog Home', 'outdoor-restaurant' ); ?>
									</a>

									<a class="outdoor-restaurant-btn outdoor-restaurant-btn-primary-outline button button-hero btn-col" href="<?php echo esc_url( admin_url( 'site-editor.php?postType=wp_template_part' ) ); ?>" target="_blank">
										<?php esc_html_e( 'All Template Parts', 'outdoor-restaurant' ); ?>
									</a>
									<a class="outdoor-restaurant-btn outdoor-restaurant-btn-primary-outline button button-hero btn-col" href="<?php echo esc_url( admin_url( 'site-editor.php?postType=wp_template&postId=' . OUTDOOR_RESTAURANT_THEME_NAME . '%2F%2Ffront-page&canvas=edit' ) ); ?>" target="_blank">
										<?php esc_html_e( 'Edit Frontpage', 'outdoor-restaurant' ); ?>
									</a>
									<a class="outdoor-restaurant-btn outdoor-restaurant-btn-primary-outline button button-hero btn-col" href="<?php echo esc_url( admin_url( 'site-editor.php?postType=wp_template&postId=' . OUTDOOR_RESTAURANT_THEME_NAME . '%2F%2Farchive&canvas=edit' ) ); ?>" target="_blank">
										<?php esc_html_e( 'Edit Archive Page', 'outdoor-restaurant' ); ?>
									</a>
									<a class="outdoor-restaurant-btn outdoor-restaurant-btn-primary-outline button button-hero btn-col" href="<?php echo esc_url( admin_url( 'site-editor.php?postType=wp_template' ) ); ?>" target="_blank">
										<?php esc_html_e( 'All Templates', 'outdoor-restaurant' ); ?>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php
				$faqs = function_exists( 'outdoor_restaurant_get_theme_faq' ) ? outdoor_restaurant_get_theme_faq() : null;
				if ( $faqs ) {
					?>
						<div class="row">
							<div class="col-12">
								<div class="outdoor-restaurant-card">
									<div class="outdoor-restaurant-card-header">
										<span class="dashicons dashicons-format-chat"></span>
										<h4 class="outdoor-restaurant-card-header-ttl">
											<?php esc_html_e( 'Frequently Asked Questions', 'outdoor-restaurant' ); ?>
										</h4>
									</div>
									<div class="outdoor-restaurant-card-body">
										<div class="outdoor-restaurant-accordion">
									<div class="outdoor-restaurant-accordion ">
									<?php foreach ( $faqs as $key => $faq ) : ?>
										<details class="outdoor-restaurant-accordion-section ">
											<summary class="outdoor-restaurant-accordion-section-title">
												<h4 class="outdoor-restaurant-accordion-heading">
													<span class="dashicons dashicons-arrow-right"></span>
													<?php echo esc_html( $faq['q'] ); ?>
												</h4>
											</summary>
											<div id="outdoor-restaurant-info-faq-<?php echo esc_attr( $key ); ?>" class="outdoor-restaurant-accordion-section-content">
												<?php echo wp_kses_post( $faq['a'] ); ?>
											</div>
										</details>
									<?php endforeach; ?>
								</div>
								</div>

									</div>
								</div>
							</div>
						</div>
					<?php
				}
				?>
			</div>

		<div class="col-lg-3">
			<div class="outdoor-restaurant-main-sidebar">
				
				<div class="outdoor-restaurant-card">
					<div class="outdoor-restaurant-card-header abc">
						<h4 class="outdoor-restaurant-card-header-ttl">
							<?php esc_html_e( 'Buy Premium Theme', 'outdoor-restaurant' ); ?>
						</h4>
					</div>

					<div class="bun-para">
						<p><?php esc_html_e( 'Our Premium WordPress Themes are crafted to deliver powerful design, seamless performance, and full customization options—perfect for building stunning, professional websites with ease.', 'outdoor-restaurant' ); ?></p>
					</div>
					
					<a href="https://www.thealphablocks.com/themes/outdoor-restaurant-wordpress-theme/" target="_blank" rel="noopener noreferrer nofollow" class="outdoor-restaurant-btn outdoor-restaurant-btn-default button button-secodary button-hero cba cbaa" target="_blank">
						<?php esc_html_e( 'Buy Now $40', 'outdoor-restaurant' ); ?>
					</a>
			
				</div>

				<div class="outdoor-restaurant-card">
					<div class="bundle-image-wrap">
			            <img src="<?php echo esc_url( get_template_directory_uri() . '/images/bundle-image.png' ); ?>">
			        </div>
					<div class="outdoor-restaurant-card-header abc">
						<h4 class="outdoor-restaurant-card-header-ttl">
							<?php esc_html_e( 'Get All Themes', 'outdoor-restaurant' ); ?>
						</h4>
					</div>

					<div class="bun-para">
						<p><?php esc_html_e( 'Whether you need a website for a blog, business, portfolio, or online store, this WP Theme Bundle provides everything you need for a visually appealing and fully functional site.', 'outdoor-restaurant' ); ?></p>
					</div>
					
					<a href="https://www.thealphablocks.com/themes/wordpress-theme-bundle/" target="_blank" rel="noopener noreferrer nofollow" class="outdoor-restaurant-btn outdoor-restaurant-btn-default button button-secodary button-hero cba" target="_blank">
						<?php esc_html_e( 'Get All Block Themes $59', 'outdoor-restaurant' ); ?>
					</a>
			
				</div>

			</div>
			</div>

		</div>
	</div>
</div>

