<?php
/**
 * Outdoor Restaurant functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Outdoor Restaurant
 */


if ( ! function_exists( 'outdoor_restaurant_support' ) ) :
	function outdoor_restaurant_support() {

		load_theme_textdomain( 'outdoor-restaurant', get_template_directory() . '/languages' );
		
		add_theme_support( 'html5', array(
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		add_theme_support( 'custom-background', apply_filters( 'outdoor_restaurant_custom_background', array(
            'default-color' => 'fafafa',
            'default-image' => '',
        )));
		
		add_theme_support( 'wp-block-styles' );

		add_editor_style( 'style.css' );

		define('OUTDOOR_RESTAURANT_BUY_NOW',__('https://www.themescarts.com/products/solar-wordpress-theme/','outdoor-restaurant'));
		define('OUTDOOR_RESTAURANT_FOOTER_BUY_NOW',__('https://www.themescarts.com/products/outdoor-restaurant/','outdoor-restaurant'));

	}
endif;
add_action( 'after_setup_theme', 'outdoor_restaurant_support' );


if ( ! function_exists( 'outdoor_restaurant_setup' ) ) :
	function outdoor_restaurant_setup() {

		load_theme_textdomain( 'outdoor-restaurant', get_template_directory() . '/languages' );
		
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'align-wide' );
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wp-block-styles' );
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 192,
				'width'       => 192,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
		add_theme_support( 'block-nav-menus' );
		add_theme_support( 'experimental-link-color' );
		register_nav_menus(
			array(
				'primary' => __( 'Primary Navigation', 'outdoor-restaurant' ),
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'outdoor_restaurant_setup' );

/**
 * Enqueue scripts and styles.
 */
function outdoor_restaurant_scripts() {
	$min  = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

	$theme_version = wp_get_theme()->get( 'Version' );

	$deps = array( 'dashicons' );
	global $wp_styles;
	if ( in_array( 'wc-blocks-vendors-style', $wp_styles->queue ) ) {
		$deps[] = 'wc-blocks-vendors-style';
	}

	wp_enqueue_style( 'outdoor-restaurant-style', get_stylesheet_uri(), $deps, date( 'Ymd-Gis', filemtime( get_theme_file_path( 'style.css' ) ) ) );

	wp_style_add_data('outdoor-restaurant', 'rtl', 'replace');

	wp_enqueue_script('outdoor-restaurant-main-script', get_template_directory_uri() . '/js/script.js', array('jquery'), OUTDOOR_RESTAURANT_VERSION, true);

		//font-awesome
	wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/css/font-awesome/css/all.css', array(), '5.15.3' );

}
add_action( 'wp_enqueue_scripts', 'outdoor_restaurant_scripts' );

/**
 * Enqueue admin scripts and styles.
 */
function outdoor_restaurant_admin_scripts() {
	$min  = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

	$theme_version = wp_get_theme()->get( 'Version' );

	$deps = array();

	wp_enqueue_style( 'outdoor-restaurant-admin-style', get_stylesheet_directory_uri() . '/css/admin-style.css', $deps, date( 'Ymd-Gis', filemtime( get_theme_file_path( 'style.css' ) ) ) );

	wp_enqueue_style(
		'outdoor-restaurant-admin-css',
		get_template_directory_uri() . '/notice-getstart/theme-info.css',
		[],
		wp_get_theme()->get( 'Version' )
	);

	// Enqueue JS
	wp_enqueue_script(
		'outdoor-restaurant-admin-js',
		get_template_directory_uri() . '/notice-getstart/theme-info.js',
		[],
		wp_get_theme()->get( 'Version' ),
		true // Load in footer
	);

}
add_action( 'admin_enqueue_scripts', 'outdoor_restaurant_admin_scripts' );

/**
 * Load core file.
 */
require_once get_template_directory() . '/core/init.php';

/**
 * TGM
 */
require_once get_template_directory() . '/core/tgm/tgm.php';



/** 
 * Customizer
 */
require get_template_directory() . '/core/section-pro/customizer.php';



/**
 * Current theme path.
 * Current theme url.
 * Current theme version.
 * Current theme name.
 * Current theme option name.
 */
define( 'OUTDOOR_RESTAURANT_PATH', trailingslashit( get_template_directory() ) );
define( 'OUTDOOR_RESTAURANT_URL', trailingslashit( get_template_directory_uri() ) );
define( 'OUTDOOR_RESTAURANT_VERSION', '1.0.0' );
define( 'OUTDOOR_RESTAURANT_THEME_NAME', 'outdoor-restaurant' );
define( 'OUTDOOR_RESTAURANT_OPTION_NAME', 'outdoor-restaurant' );

/**
 * The core theme class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require OUTDOOR_RESTAURANT_PATH . 'notice-getstart/main.php';


/**
 * Begins execution of the theme.
 *
 * @since    1.0.0
 */
function outdoor_restaurant_run() {
	new Outdoor_Restaurant();
}
outdoor_restaurant_run();





