<?php
/**
* Template part for displaying front page introduction.
*
* @package Ostrich Business
*/

// Get the content type.
$video = get_theme_mod( 'ostrich_business_video', 'disable' );
// Bail if the section is disabled.
if ( 'disable' === $video ) {
    return;
}
$video_btn    = get_theme_mod( 'ostrich_business_video_btn_title', __( 'Learn MORE', 'ostrich-business') ) ;
$sub_title    = get_theme_mod( 'ostrich_business_video_sub_title', __( 'Our Video', 'ostrich-business') ) ;
$get_content = ostrich_business_get_section_content( 'video', $video, 1  );
?>

<div id="video" class="pt">
    <div class="container">
        <?php foreach ( $get_content as $content ): ?>
            <article  id="box4" class="has-post-thumbnail aos_container">
                <div class="entry-container">
                    <div class="section-header">
                        <?php if( !empty( $sub_title ) ): ?>
                            <p class="section-subtitle"><?php echo esc_html( $sub_title ); ?></p>
                        <?php endif; ?>
                        <h2 class="section-title"><?php echo esc_html( $content['title'] ); ?></h2>
                    </div><!-- .section-header -->

                    <div class="entry-content">
                        <p><?php echo esc_html( wp_trim_words( $content['content'], 45 ) ); ?></p> 
                    </div><!-- .entry-content -->

                    <?php if( !empty( $video_btn ) ): ?>
                        <div class="read-more">
                            <a href="<?php echo esc_url( $content['url'] ) ; ?>" class="button"><?php echo esc_html( $video_btn ); ?></a>
                        </div>
                    <?php endif; ?>
                </div><!-- .entry-container -->

                <div class="featured-image" style="background-image: url('<?php echo esc_url( get_the_post_thumbnail_url( $content['id'] ) ) ; ?>');">
                    <a href="<?php echo esc_url( $content['url'] ) ; ?>" class="post-thumbnail-link"></a>
                    <?php if( !empty( get_theme_mod( 'ostrich_business_video_url') ) ): ?>
                        <div class="video-button aos_content">
                            <a href="<?php echo esc_url( get_theme_mod( 'ostrich_business_video_url') ); ?>" class="popup-youtube aos_content" >
                                <svg class="svg-inline--fa fa-play fa-w-14" viewBox="0 0 448 512"><path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z"></path></svg>
                            </a>
                        </div>
                    <?php endif; ?>
                </div><!-- .featured-image -->
            </article>
        <?php endforeach; ?>    
    </div><!-- .container -->
</div><!-- #video -->