<?php
/**
 * Blog/Archive section 
 */
// Blog/Archive section 
$wp_customize->add_section(
	'ostrich_business_archive_settings',
	array(
		'title' => esc_html__( 'Archive/Blog', 'ostrich-business' ),
		'description' => esc_html__( 'Settings for archive pages including blog page too.', 'ostrich-business' ),
		'panel' => 'ostrich_business_general_panel',
	)
);

// Archive excerpt length setting
$wp_customize->add_setting(
	'ostrich_business_archive_excerpt_length',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_number_range',
		'default' => 20,
	)
);

$wp_customize->add_control(
	'ostrich_business_archive_excerpt_length',
	array(
		'section'		=> 'ostrich_business_archive_settings',
		'label'			=> esc_html__( 'Excerpt more length:', 'ostrich-business' ),
		'type'			=> 'number',
		'input_attrs'   => array( 'min' => 5 ),
	)
);

// Pagination type setting
$wp_customize->add_setting(
	'ostrich_business_archive_pagination_type',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_select',
		'default' => 'numeric',
	)
);

$archive_pagination_description = '';
$archive_pagination_choices = array( 
			'disable' => esc_html__( '--Disable--', 'ostrich-business' ),
			'numeric' => esc_html__( 'Numeric', 'ostrich-business' ),
			'older_newer' => esc_html__( 'Older / Newer', 'ostrich-business' ),
		);

$wp_customize->add_control(
	'ostrich_business_archive_pagination_type',
	array(
		'section'		=> 'ostrich_business_archive_settings',
		'label'			=> esc_html__( 'Pagination type:', 'ostrich-business' ),
		'description'			=>  $archive_pagination_description,
		'type'			=> 'select',
		'choices'		=> $archive_pagination_choices,
	)
);

$wp_customize->add_setting(
	'ostrich_business_archive_layout',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_select',
		'default' => 'col-2',
	)
);

$wp_customize->add_control(
	'ostrich_business_archive_layout',
	array(
		'section'		=> 'ostrich_business_archive_settings',
		'label'			=> esc_html__( 'Archive Layout', 'ostrich-business' ),
		'type'			=> 'select',
		'choices'		=> array(
				'list-layout' 	=> esc_html__( 'List Layout', 'ostrich-business' ),
				'col-1' 		=> esc_html__( 'Column One', 'ostrich-business' ),
				'col-2' 		=> esc_html__( 'Column Two', 'ostrich-business' ),
				'col-3' 		=> esc_html__( 'Column Three', 'ostrich-business' ),
		),
	)
);