<?php
/**
 * Theme Ostrich Customizer
 *
 * @package Ostrich Business
 *
 * video section
 */
$wp_customize->add_section(
	'ostrich_business_video',
	array(
		'title' => esc_html__( 'Video', 'ostrich-business' ),
		'panel' => 'ostrich_business_home_panel',
	)
);

// blog enable settings
$wp_customize->add_setting(
	'ostrich_business_video',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_select',
		'default' => 'disable',
	)
);
$wp_customize->add_control(
	'ostrich_business_video',
	array(
		'section'		=> 'ostrich_business_video',
		'label'			=> esc_html__( 'Content type:', 'ostrich-business' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'ostrich-business' ),
		'type'			=> 'select',
		'choices'		=> array(
				'disable' => esc_html__( '--Disable--', 'ostrich-business' ),
				'page' => esc_html__( 'Page', 'ostrich-business' ),
		 	)
	)
);

$wp_customize->add_setting(
	'ostrich_business_video_sub_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'Our Video', 'ostrich-business' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'ostrich_business_video_sub_title',
	array(
		'section'		=> 'ostrich_business_video',
		'label'			=> esc_html__( 'Sub Title:', 'ostrich-business' ),
		'active_callback'	=> 'ostrich_business_if_video_enabled',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_video_sub_title', 
	array(
        'selector'            => '#video p.section-subtitle',
		'render_callback'     => 'ostrich_business_video_partial_subtitle',
	) 
);

for ($i=1; $i <= 1 ; $i++) {

	// blog page setting
	$wp_customize->add_setting(
		'ostrich_business_video_page_'.$i,
		array(
			'sanitize_callback' => 'ostrich_business_sanitize_dropdown_pages',
			'default' => 0,
		)
	);
	$wp_customize->add_control(
		'ostrich_business_video_page_'.$i,
		array(
			'section'		=> 'ostrich_business_video',
			'label'			=> esc_html__( 'Page ', 'ostrich-business' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'ostrich_business_if_video_page'
		)
	);
}

$wp_customize->add_setting(
		'ostrich_business_video_url',
		array(
			'sanitize_callback' => 'esc_url_raw',
		)
	);
	
	$wp_customize->add_control(
		'ostrich_business_video_url',
		array(
			'section'		=> 'ostrich_business_video',
			'label'			=> esc_html__( 'Video Url:', 'ostrich-business' ),
			'type'			=> 'url',
			'active_callback'	=> 'ostrich_business_if_video_enabled',
		)
	);

$wp_customize->add_setting(
	'ostrich_business_video_btn_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'Learn More', 'ostrich-business' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'ostrich_business_video_btn_title',
	array(
		'section'		=> 'ostrich_business_video',
		'label'			=> esc_html__( 'Btn Title:', 'ostrich-business' ),
		'active_callback'	=> 'ostrich_business_if_video_enabled',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_video_btn_title', 
	array(
        'selector'            => '#video div.read-more a',
		'render_callback'     => 'ostrich_business_video_partial_btn_title',
	) 
);