<?php
/**
 * Theme Ostrich Customizer
 *
 * @package Ostrich Business
 *
 * topbar
 */

$wp_customize->add_section(
	'ostrich_business_topbar',
	array(
		'title' => esc_html__( 'Top bar', 'ostrich-business' ),
		'panel' => 'ostrich_business_home_panel',
	)
);

// topbar enable settings
$wp_customize->add_setting(
	'ostrich_business_topbar',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_checkbox',
		'default' => false,
	)
);

$wp_customize->add_control(
	'ostrich_business_topbar',
	array(
		'section'		=> 'ostrich_business_topbar',
		'label'			=> esc_html__( 'Enable Topbar', 'ostrich-business' ),
		'type'			=> 'checkbox',
	)
);


$wp_customize->add_setting(
	'ostrich_business_topbar_menu',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_checkbox',
		'default' => false,
	)
);

$wp_customize->add_control(
	'ostrich_business_topbar_menu',
	array(
		'section'		=> 'ostrich_business_topbar',
		'label'			=> esc_html__( 'Enable Topbar Menu', 'ostrich-business' ),
		'type'			=> 'checkbox',
	)
);

$wp_customize->add_setting(
	'ostrich_business_topbar_icon',
	array(	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'ostrich_business_topbar_icon',
	array(
	'label'       => __('Icon ', 'ostrich-business'),
	'description' => sprintf( __('Please input icon as eg: fa-archive. Find Font-awesome icons %1$shere%2$s', 'ostrich-business'), '<a href="' . esc_url( 'https://fontawesome.com/v4.7.0/cheatsheet/' ) . '" target="_blank">', '</a>' ),
	'section'     => 'ostrich_business_topbar',   	
	'type'        => 'text'
	)
);

$wp_customize->add_setting(
	'ostrich_business_topbar_textfield',
	array(	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'ostrich_business_topbar_textfield',
	array(
	'label'       => __('Contact Text', 'ostrich-business'),  
	'section'     => 'ostrich_business_topbar',   		
	'type'        => 'text'
	)
);

$wp_customize->add_setting(
	'ostrich_business_topbar_contact_number',
	array(	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'ostrich_business_topbar_contact_number',
	array(
	'label'       => __('Contact Number', 'ostrich-business'),  
	'section'     => 'ostrich_business_topbar',   		
	'type'        => 'text'
	)
);