<?php
/**
 * Ostrich Theme Customizer
 *
 * @package Ostrich Business Theme
 *
 * Team section
 */

$wp_customize->add_section(
	'ostrich_business_team',
	array(
		'title' => esc_html__( 'Team', 'ostrich-business' ),
		'panel' => 'ostrich_business_home_panel',
	)
);

// team enable settings
$wp_customize->add_setting(
	'ostrich_business_team',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_select',
		'default' => 'disable'
	)
);

$wp_customize->add_control(
	'ostrich_business_team',
	array(
		'section'		=> 'ostrich_business_team',
		'label'			=> esc_html__( 'Content type:', 'ostrich-business' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'ostrich-business' ),
		'type'			=> 'select',		
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'ostrich-business' ),
				'page' => esc_html__( 'Page', 'ostrich-business' ),
		 	)
	)
);

$wp_customize->add_setting(
	'ostrich_business_team_sub_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'transport'	=> 'postMessage',
		'default'	=>  __('Our Members', 'ostrich-business'),
	)
);

$wp_customize->add_control(
	'ostrich_business_team_sub_title',
	array(
		'section'		=> 'ostrich_business_team',
		'label'			=> esc_html__( 'Sub Title:', 'ostrich-business' ),
		'active_callback' => 'ostrich_business_if_team_enabled',	
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_team_sub_title', 
	array(
        'selector'            => '#our-team p.section-subtitle',
		'render_callback'     => 'ostrich_business_team_partial_sub_title',
	) 
);

$wp_customize->add_setting(
	'ostrich_business_team_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'transport'	=> 'postMessage',
		'default'	=>  __('Here is Our Awesome Team', 'ostrich-business'),
	)
);

$wp_customize->add_control(
	'ostrich_business_team_title',
	array(
		'section'		=> 'ostrich_business_team',
		'label'			=> esc_html__( 'Title:', 'ostrich-business' ),		
		'active_callback' => 'ostrich_business_if_team_enabled',
		
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_team_title', 
	array(
        'selector'            => '#our-team h2.section-title',
		'render_callback'     => 'ostrich_business_team_partial_title',
	) 
);

for ($i=1; $i <= 3; $i++) { 

	// team page setting
	$wp_customize->add_setting(
		'ostrich_business_team_page_'.$i,
		array(
			'sanitize_callback' => 'ostrich_business_sanitize_dropdown_pages',
			'default' => 0,
		)
	);

	$wp_customize->add_control(
		'ostrich_business_team_page_'.$i,
		array(
			'section'		=> 'ostrich_business_team',
			'label'			=> esc_html__( 'Page ', 'ostrich-business' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'ostrich_business_if_team_page'
		)
	);

	$wp_customize->add_setting(
		'ostrich_business_team_position_'.$i,
		array(
			'sanitize_callback' => 'sanitize_text_field',
			'transport'	=> 'refresh',
		)
	);

	$wp_customize->add_control(
		'ostrich_business_team_position_'.$i,
		array(
			'section'		=> 'ostrich_business_team',
			'label'			=> esc_html__( 'Members Position:', 'ostrich-business' ). $i,
			'active_callback' => 'ostrich_business_if_team_enabled',	
		)
	);

}