<?php
/**
 * Theme Ostrich Customizer
 *
 * @package Ostrich Business
 *
 * slider section
 */

$wp_customize->add_section(
	'ostrich_business_slider',
	array(
		'title' => esc_html__( 'Slider Section', 'ostrich-business' ),
		'panel' => 'ostrich_business_home_panel',
	)
);

// slider enable settings
$wp_customize->add_setting(
	'ostrich_business_slider',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_select',
		'default' => 'disable'
	)
);

$wp_customize->add_control(
	'ostrich_business_slider',
	array(
		'section'		=> 'ostrich_business_slider',
		'label'			=> esc_html__( 'Content type:', 'ostrich-business' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'ostrich-business' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'ostrich-business' ),
				'page' => esc_html__( 'Page', 'ostrich-business' ),
		 	)
	)
);

for ($i=1; $i <= 3; $i++) { 
	
	// slider page setting
	$wp_customize->add_setting(
		'ostrich_business_slider_page_'.$i,
		array(
			'sanitize_callback' => 'ostrich_business_sanitize_dropdown_pages',
			'default' => 0,
		)
	);

	$wp_customize->add_control(
		'ostrich_business_slider_page_'.$i,
		array(
			'section'		=> 'ostrich_business_slider',
			'label'			=> esc_html__( 'Page ', 'ostrich-business' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'ostrich_business_if_slider_page'
		)
	);
}

$wp_customize->add_setting(
	'ostrich_business_slider_button_label',
	array(	
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> esc_html__( 'Learn More', 'ostrich-business' ),
	'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'ostrich_business_slider_button_label',
	array(
	'label'       => __('Button Label', 'ostrich-business'),  
	'section'     => 'ostrich_business_slider',   		
	'type'        => 'text',
	'active_callback'	=> 'ostrich_business_if_slider_enabled',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_slider_button_label', 
	array(
        'selector'            => '#hero-slider div.read-more a',
		'render_callback'     => 'ostrich_business_slider_partial_button',
	) 
);
