<?php
/**
 * Ostrich Theme Customizer
 *
 * @package Ostrich Business Theme
 *
 * service section
 */

$wp_customize->add_section(
	'ostrich_business_service',
	array(
		'title' => esc_html__( 'service', 'ostrich-business' ),
		'panel' => 'ostrich_business_home_panel',
	)
);

// service enable settings
$wp_customize->add_setting(
	'ostrich_business_service',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_select',
		'default' => 'disable'
	)
);

$wp_customize->add_control(
	'ostrich_business_service',
	array(
		'section'		=> 'ostrich_business_service',
		'label'			=> esc_html__( 'Content type:', 'ostrich-business' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'ostrich-business' ),
		'type'			=> 'select',		
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'ostrich-business' ),
				'page' => esc_html__( 'Page', 'ostrich-business' ),
		 	)
	)
);

$wp_customize->add_setting(
	'ostrich_business_service_sub_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'transport'	=> 'postMessage',
		'default'	=>  __('Our Services', 'ostrich-business'),
	)
);

$wp_customize->add_control(
	'ostrich_business_service_sub_title',
	array(
		'section'		=> 'ostrich_business_service',
		'label'			=> esc_html__( 'Sub Title:', 'ostrich-business' ),
		'active_callback' => 'ostrich_business_if_service_enabled',	
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_service_sub_title', 
	array(
        'selector'            => '#our-service p.section-subtitle',
		'render_callback'     => 'ostrich_business_service_partial_sub_title',
	) 
);

$wp_customize->add_setting(
	'ostrich_business_service_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'transport'	=> 'postMessage',
		'default'	=>  __('Here is Our Awesome Services', 'ostrich-business'),
	)
);

$wp_customize->add_control(
	'ostrich_business_service_title',
	array(
		'section'		=> 'ostrich_business_service',
		'label'			=> esc_html__( 'Title:', 'ostrich-business' ),		
		'active_callback' => 'ostrich_business_if_service_enabled',
		
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_service_title', 
	array(
        'selector'            => '#our-service h2.section-title',
		'render_callback'     => 'ostrich_business_service_partial_title',
	) 
);

for ($i=1; $i <= 3; $i++) { 

	// service page setting
	$wp_customize->add_setting(
		'ostrich_business_service_page_'.$i,
		array(
			'sanitize_callback' => 'ostrich_business_sanitize_dropdown_pages',
			'default' => 0,
		)
	);

	$wp_customize->add_control(
		'ostrich_business_service_page_'.$i,
		array(
			'section'		=> 'ostrich_business_service',
			'label'			=> esc_html__( 'Page ', 'ostrich-business' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'ostrich_business_if_service_page'
		)
	);
}