<?php
/**
 * Theme Ostrich Customizer
 *
 * @package Ostrich Business
 *
 * recent_news section
 */

$wp_customize->add_section(
	'ostrich_business_recent_news',
	array(
		'title' => esc_html__( 'Blog Section', 'ostrich-business' ),
		'panel' => 'ostrich_business_home_panel',
	)
);

// recent_news enable settings
$wp_customize->add_setting(
	'ostrich_business_recent_news',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_select',
		'default' => 'disable'
	)
);

$wp_customize->add_control(
	'ostrich_business_recent_news',
	array(
		'section'		=> 'ostrich_business_recent_news',
		'label'			=> esc_html__( 'Content type:', 'ostrich-business' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'ostrich-business' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'ostrich-business' ),
				'page' => esc_html__( 'Page', 'ostrich-business' ),
				'cat' => esc_html__( 'Category', 'ostrich-business' ),
		 	)
	)
);

$wp_customize->add_setting(
	'ostrich_business_recent_news_sub_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'transport'	=> 'postMessage',
		'default'	=>  __('Recent News', 'ostrich-business'),
	)
);

$wp_customize->add_control(
	'ostrich_business_recent_news_sub_title',
	array(
		'section'		=> 'ostrich_business_recent_news',
		'label'			=> esc_html__( 'Sub Title:', 'ostrich-business' ),
		'active_callback' => 'ostrich_business_if_recent_news_enabled',
		
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_recent_news_sub_title', 
	array(
        'selector'            => '#recent-news p.section-subtitle',
		'render_callback'     => 'ostrich_business_recent_news_partial_sub_title',
	) 
);

$wp_customize->add_setting(
	'ostrich_business_recent_news_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'transport'	=> 'postMessage',
		'default'	=>  __('Choose Your Perfect Plan', 'ostrich-business'),
	)
);

$wp_customize->add_control(
	'ostrich_business_recent_news_title',
	array(
		'section'		=> 'ostrich_business_recent_news',
		'label'			=> esc_html__( 'Title:', 'ostrich-business' ),		
		'active_callback' => 'ostrich_business_if_recent_news_enabled',
		
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_recent_news_title', 
	array(
        'selector'            => '#recent-news h2.section-title',
		'render_callback'     => 'ostrich_business_recent_news_partial_title',
	) 
);

for ($i=1; $i <= 6; $i++) { 

	// recent_news page setting
	$wp_customize->add_setting(
		'ostrich_business_recent_news_page_'.$i,
		array(
			'sanitize_callback' => 'ostrich_business_sanitize_dropdown_pages',
			'default' => 0,
		)
	);

	$wp_customize->add_control(
		'ostrich_business_recent_news_page_'.$i,
		array(
			'section'		=> 'ostrich_business_recent_news',
			'label'			=> esc_html__( 'Page ', 'ostrich-business' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'ostrich_business_if_recent_news_page'
		)
	);
}

// recent_news category setting
$wp_customize->add_setting(
	'ostrich_business_recent_news_cat',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_select',
	)
);

$wp_customize->add_control(
	'ostrich_business_recent_news_cat',
	array(
		'section'		=> 'ostrich_business_recent_news',
		'label'			=> esc_html__( 'Category:', 'ostrich-business' ),
		'active_callback' => 'ostrich_business_if_recent_news_cat',
		'type'			=> 'select',
		'choices'		=> ostrich_business_get_post_cat_choices(),
	)
);
