<?php
/**
 * Theme Ostrich Customizer
 *
 * @package Ostrich Business
 *
 * cta section
 */
$wp_customize->add_section(
	'ostrich_business_cta',
	array(
		'title' => esc_html__( 'Cta', 'ostrich-business' ),
		'panel' => 'ostrich_business_home_panel',
	)
);


// blog enable settings
$wp_customize->add_setting(
	'ostrich_business_cta',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_select',
		'default' => 'disable',
	)
);
$wp_customize->add_control(
	'ostrich_business_cta',
	array(
		'section'		=> 'ostrich_business_cta',
		'label'			=> esc_html__( 'Content type:', 'ostrich-business' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'ostrich-business' ),
		'type'			=> 'select',
		'choices'		=> array(
				'disable' 	=> esc_html__( '--Disable--', 'ostrich-business' ),
				'page' 		=> esc_html__( 'Page', 'ostrich-business' ),
		 	)
	)
);

$wp_customize->add_setting(
	'ostrich_business_cta_sub_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'GET SOLUTIONS FAST', 'ostrich-business' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'ostrich_business_cta_sub_title',
	array(
		'section'		=> 'ostrich_business_cta',
		'label'			=> esc_html__( 'Sub Title:', 'ostrich-business' ),
		'active_callback'	=> 'ostrich_business_if_cta_enabled',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_cta_sub_title', 
	array(
        'selector'            => '#call-to-action p.section-subtitle',
		'render_callback'     => 'ostrich_business_cta_partial_subtitle',
	) 
);

$wp_customize->add_setting( 
		'ostrich_business_cta_bg_image',
		array(
			'sanitize_callback' => 'ostrich_business_sanitize_image',
		) 
	);

	$wp_customize->add_control( 
		new WP_Customize_Image_Control( $wp_customize, 'ostrich_business_cta_bg_image',
		array(
			'label'       		=> esc_html__( 'cta Image', 'ostrich-business' ),
			'section'     		=> 'ostrich_business_cta',
			'active_callback'	=> 'ostrich_business_if_cta_enabled',
		)
	) );

for ($i=1; $i <= 1 ; $i++) {
	
	// blog page setting
	$wp_customize->add_setting(
		'ostrich_business_cta_page_'.$i,
		array(
			'sanitize_callback' => 'ostrich_business_sanitize_dropdown_pages',
			'default' => 0,
		)
	);
	$wp_customize->add_control(
		'ostrich_business_cta_page_'.$i,
		array(
			'section'		=> 'ostrich_business_cta',
			'label'			=> esc_html__( 'Page ', 'ostrich-business' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'ostrich_business_if_cta_page'
		)
	);
}

$wp_customize->add_setting(
	'ostrich_business_cta_btn',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'GET A QUOTE HERE', 'ostrich-business' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'ostrich_business_cta_btn',
	array(
		'section'		=> 'ostrich_business_cta',
		'label'			=> esc_html__( 'Button Label:', 'ostrich-business' ),
		'active_callback'	=> 'ostrich_business_if_cta_enabled',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_cta_btn', 
	array(
        'selector'            => '#call-to-action div.read-more a',
		'render_callback'     => 'ostrich_business_cta_partial_btn',
	) 
);

