<?php
/**
 * Theme Ostrich Customizer
 *
 * @package Ostrich Business
 *
 * about section
 */
$wp_customize->add_section(
	'ostrich_business_about',
	array(
		'title' => esc_html__( 'About', 'ostrich-business' ),
		'panel' => 'ostrich_business_home_panel',
	)
);

// blog enable settings
$wp_customize->add_setting(
	'ostrich_business_about',
	array(
		'sanitize_callback' => 'ostrich_business_sanitize_select',
		'default' => 'disable',
	)
);
$wp_customize->add_control(
	'ostrich_business_about',
	array(
		'section'		=> 'ostrich_business_about',
		'label'			=> esc_html__( 'Content type:', 'ostrich-business' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'ostrich-business' ),
		'type'			=> 'select',
		'choices'		=> array(
				'disable' => esc_html__( '--Disable--', 'ostrich-business' ),
				'page' => esc_html__( 'Page', 'ostrich-business' ),
		 	)
	)
);

$wp_customize->add_setting(
	'ostrich_business_about_sub_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'About Us', 'ostrich-business' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'ostrich_business_about_sub_title',
	array(
		'section'		=> 'ostrich_business_about',
		'label'			=> esc_html__( 'Sub Title:', 'ostrich-business' ),
		'active_callback'	=> 'ostrich_business_if_about_enabled',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'ostrich_business_about_sub_title', 
	array(
        'selector'            => '#about p.section-subtitle',
		'render_callback'     => 'ostrich_business_about_partial_subtitle',
	) 
);

for ($i=1; $i <= 1 ; $i++) {

	// blog page setting
	$wp_customize->add_setting(
		'ostrich_business_about_page_'.$i,
		array(
			'sanitize_callback' => 'ostrich_business_sanitize_dropdown_pages',
			'default' => 0,
		)
	);
	$wp_customize->add_control(
		'ostrich_business_about_page_'.$i,
		array(
			'section'		=> 'ostrich_business_about',
			'label'			=> esc_html__( 'Page ', 'ostrich-business' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'ostrich_business_if_about_page'
		)
	);
}