<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Ostrich Business
 */
?>
<!doctype html>
<html <?php language_attributes(); ?> >
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
    
</head>
 
<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'ostrich-business' ); ?></a>
    
    <div class="menu-overlay"></div>
    <?php if ( get_theme_mod( 'ostrich_business_topbar' ) == true ): ?>
        <div id="top-bar" class="relative">
            
             <button class="secondary-menu" aria-controls="primary-menu" aria-expanded="false">
                    <span class="menu-label"><?php echo esc_html__('Menu', 'ostrich-business'); ?></span>
                     <svg viewBox="0 0 284.929 284.929" class="dropdown-icon icon-up">
                    <path d="M282.082,195.285L149.028,62.24c-1.901-1.903-4.088-2.856-6.562-2.856s-4.665,0.953-6.567,2.856L2.856,195.285C0.95,197.191,0,199.378,0,201.853c0,2.474,0.953,4.664,2.856,6.566l14.272,14.271c1.903,1.903,4.093,2.854,6.567,2.854c2.474,0,4.664-0.951,6.567-2.854l112.204-112.202l112.208,112.209c1.902,1.903,4.093,2.848,6.563,2.848c2.478,0,4.668-0.951,6.57-2.848l14.274-14.277c1.902-1.902,2.847-4.093,2.847-6.566C284.929,199.378,283.984,197.188,282.082,195.285z"></path>
                </svg>
                <svg viewBox="0 0 129 129" class="dropdown-icon icon-down">
                    <path d="m121.3,34.6c-1.6-1.6-4.2-1.6-5.8,0l-51,51.1-51.1-51.1c-1.6-1.6-4.2-1.6-5.8,0-1.6,1.6-1.6,4.2 0,5.8l53.9,53.9c0.8,0.8 1.8,1.2 2.9,1.2 1,0 2.1-0.4 2.9-1.2l53.9-53.9c1.7-1.6 1.7-4.2 0.1-5.8z"></path>
                </svg>
            </button>

            <div class="container open">
                <div class="col-2 clear">
                    <div class="hentry">
                        <ul class="contact-info">
                            <li>
                                <i class="fa <?php echo esc_attr(  get_theme_mod( 'ostrich_business_topbar_icon' ) ); ?>"> </i>
                                <?php echo esc_html( get_theme_mod( 'ostrich_business_topbar_textfield' ) ) ?><a href="tel:<?php echo esc_attr( get_theme_mod( 'ostrich_business_topbar_contact_number' )  ) ; ?>"><?php echo esc_html( get_theme_mod( 'ostrich_business_topbar_contact_number' )  ) ; ?></a>
                            </li>
                        </ul><!-- .contact-info -->
                    </div><!-- .hentry -->

                    <div class="hentry">
                        <div class="secondary-menu">
                            <?php if ( has_nav_menu('secondary') ): ?>
                                <?php if ( get_theme_mod( 'ostrich_business_topbar_menu' ) == true ): ?>
                                        <?php 
                                            wp_nav_menu( array(
                                                'theme_location' => 'secondary',
                                                'menu_class'     => 'menu nav-menu',
                                            ) );
                                        ?>
                                <?php endif ?>
                                <?php elseif( current_user_can( 'edit_theme_options' ) ): ?>
                                        <li><a href="<?php echo esc_url( admin_url( 'nav-menus.php' ) ); ?>"><?php echo esc_html__( 'Add a menu', 'ostrich-business' ); ?></a></li>
                            <?php endif ?>
                        </div><!-- .secondary-menu -->
                    </div><!-- .hentry -->
                </div><!-- .col-2 -->
            </div><!-- .container -->
        </div>

    <?php endif ?>

    <?php get_template_part( 'template-parts/header' );  ?>
    
	<div id="content" class="site-content">
