<?php
/**
 * Enqueue CSS styles
 */
add_action( 'wp_enqueue_scripts', 'osom_styles' );
function osom_styles() {
	wp_enqueue_style( 'osom-style', get_stylesheet_uri() );
}

/**
 * Prevent the loading of patterns from the WordPress.org Pattern Directory
 */
add_filter( 'should_load_remote_block_patterns', '__return_false' );

/**
 * Remove patterns that ship with WordPress Core
 */
add_action( 'after_setup_theme', 'osom_remove_core_block_patterns' );
function osom_remove_core_block_patterns() {
	remove_theme_support( 'core-block-patterns' );
}

/**
 * Register new patterns category
 */
add_action( 'init', 'osom_register_patterns' );
function osom_register_patterns() {
	if ( function_exists( 'register_block_pattern_category' ) ) {
		register_block_pattern_category(
			'osompress',
			array(
				'label'       => __( 'OsomPress', 'osom-business' ),
				'description' => __( 'OsomPress themes patterns', 'osom-business' ),
			)
		);
	}
}

/**
 * Register block styles
 */
add_action( 'init', 'osom_register_block_styles' );
function osom_register_block_styles() {
	register_block_style(
		'core/paragraph',
		array(
			'name'         => 'intro',
			'label'        => __( 'Intro Paragraph Block', 'osom-business' ),
			'is_default'   => false,
			'inline_style' => 'p.is-style-intro {  text-align: center;  max-width: 600px; margin: 0 auto; }',
		)
	);

	register_block_style(
		'core/heading',
		array(
			'name'         => 'osom-title',
			'label'        => __( 'Osom Style Title', 'osom-business' ),
			'is_default'   => false,
			'inline_style' => '.is-style-osom-title:before, .is-style-osom-title:after { content: ""; display: inline-block; width: 30px; height: 1px; background-color: var(--wp--preset--color--primary); vertical-align: middle; margin: 0 20px; } @media only screen and (max-width: 600px) { .is-style-osom-title:before, .is-style-osom-title:after { display:none; } }',
		)
	);

	register_block_style(
		'core/post-title',
		array(
			'name'         => 'osom-title',
			'label'        => __( 'Osom Style Title', 'osom-business' ),
			'is_default'   => false,
			'inline_style' => '.is-style-osom-title:before, .is-style-osom-title:after { content: ""; display: inline-block; width: 30px; height: 1px; background-color: var(--wp--preset--color--primary); vertical-align: middle; margin: 0 20px; } @media only screen and (max-width: 600px) { .is-style-osom-title:before, .is-style-osom-title:after { display:none; } }',
		)
	);

	register_block_style(
		'core/image',
		array(
			'name'         => 'osom-featured',
			'label'        => __( 'Osom Featured Image', 'osom-business' ),
			'is_default'   => false,
			'inline_style' => '.is-style-osom-featured figcaption{ background: var(--wp--preset--color--primary) !important; color: var(--wp--preset--color--background); text-align: center; margin-top: 0; padding: 5px !important; }',
		)
	);

	register_block_style(
		'core/list',
		array(
			'name'         => 'osom-checked',
			'label'        => __( 'Checked', 'osom-business' ),
			'is_default'   => false,
			'inline_style' => '.is-style-osom-checked li { list-style-type: none!important; padding-left: 8px; position: relative; } ol.is-style-osom-checked li:before, ul.is-style-osom-checked li:before {  content:""; background-size: cover;  display: inline-block;  height: 25px;  left: -25px;  position: absolute;  top: 1em;  margin-top: -18px;  transform: scale(.9);  width: 25px;  background: var(--wp--preset--color--foreground); mask-repeat: no-repeat;  -webkit-mask-repeat: no-repeat;  mask-image: url(\'data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" ><path fill="none" d="M0 0h24v24H0z"></path><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path></svg>\');-webkit-mask-image: url(\'data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" ><path fill="none" d="M0 0h24v24H0z"></path><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path></svg>\') }',

		)
	);

	register_block_style(
		'core/list',
		array(
			'name'         => 'osom-star',
			'label'        => __( 'Starred', 'osom-business' ),
			'is_default'   => false,
			'inline_style' => '.is-style-osom-star li { list-style-type: none!important; padding-left: 8px; position: relative; } ol.is-style-osom-checked li:before, ul.is-style-osom-star li:before {  content:""; background-size: cover;  display: inline-block;  height: 20px;  left: -20px;  position: absolute;  top: 1em;  margin-top: -14px;  transform: scale(.9);  width: 20px;  background: var(--wp--preset--color--foreground); mask-repeat: no-repeat;  -webkit-mask-repeat: no-repeat;  mask-image: url(\'data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 512 512" ><path fill="none" d="M0 0h512v512H0z"></path><path d="M496 203.3H312.36L256 32l-56.36 171.3H16l150.21 105.4-58.5 171.3L256 373.84 404.29 480l-58.61-171.3Z"></path></svg>\');-webkit-mask-image: url(\'data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 512 512" ><path fill="none" d="M0 0h512v512H0z"></path><path d="M496 203.3H312.36L256 32l-56.36 171.3H16l150.21 105.4-58.5 171.3L256 373.84 404.29 480l-58.61-171.3Z"></path></svg>\') }',

		)
	);

	register_block_style(
		'core/search',
		array(
			'name'         => 'osom-search',
			'label'        => __( 'Osom Search', 'osom-business' ),
			'is_default'   => false,
			'inline_style' => '.is-style-osom-search .wp-block-search__input { background: none !important; border-bottom: solid 1px  var(--wp--preset--color--primary) !important; font-family: var(--wp--preset--font-family--raleway)} .is-style-osom-search .wp-block-search__inside-wrapper .wp-block-search__button { border-radius: 4px;}',
		)
	);

	register_block_style(
		'core/details',
		array(
			'name'         => 'osom-details',
			'label'        => __( 'Osom Details', 'osom-business' ),
			'is_default'   => false,
			'inline_style' => '.is-style-osom-details[open] {
				border: solid 1px var(--wp--preset--color--secondary);
				padding-bottom: 30px; }   .is-style-osom-details summary {
				background: var(--wp--preset--color--secondary); 	padding: 15px; margin: 0; } .is-style-osom-details summary:hover {  filter: brightness(0.9); } .is-style-osom-details > * { margin: 10px 20px; margin-block-start: 1.5rem; } .alignfull .is-style-osom-details[open] {
					border: none;
				}',
		)
	);
}
