<?php get_header(); ?>
<?php get_template_part('inc/breadcrumb'); ?>
<main id="main-content" tabindex="-1">
  <section class="blog-post-page">
    <div class="container">
      <div class="row">
        <?php if (have_posts()) : ?>
          <?php while (have_posts()) : the_post(); ?>
            <div id="post-<?php the_ID(); ?>" <?php post_class('col-md-9 blog-content-area'); ?>>
              <div class="blog-post-area">
                <div class="post-title">
                  <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                  <div class="post-meta">
                    <div class="post-meta-item">
                      <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"
                        title="View all posts by <?php echo esc_attr(get_the_author()); ?>">
                        <i class="fa-regular fa-user"></i><?php the_author(); ?>
                      </a>
                    </div>
                    <div class="post-meta-item">
                      <a href="#">
                        <i class="fa-regular fa-comments"></i>
                        <span><?php comments_popup_link(__('Leave a comment', 'oryncart'), __('1 Comment', 'oryncart'), __('% Comments', 'oryncart')); ?></span>
                      </a>
                    </div>
                    <?php
                    $archive_year = get_the_time('Y');
                    $archive_month = get_the_time('m');
                    $archive_time = get_the_time('d');
                    ?>
                    <div class="post-meta-item">
                      <span>
                        <a href="<?php echo esc_url(get_day_link($archive_year, $archive_month, $archive_time)); ?>">
                          <i class="fa-regular fa-calendar-days"></i><?php the_time('j F, Y'); ?>
                        </a>
                      </span>
                    </div>
                  </div>
                </div>
                <div class="post-body">
                  <p><?php echo esc_html(get_the_excerpt()); ?></p>
                  <div class="post-images">
                    <?php if (has_post_thumbnail()) : ?>
                      <?php the_post_thumbnail('medium-large', array('class' => 'img-fluid w-100')); ?>
                    <?php endif; ?>
                  </div>
                  <p><?php echo esc_html(get_the_excerpt()); ?></p>
                </div>
                <?php
                the_content();
                wp_link_pages(array(
                  'before' => '<div class="page-links">' . __('Pages:', 'oryncart'),
                  'after'  => '</div>',
                  'link_before' => '<span>',
                  'link_after'  => '</span>',
                  'next_or_number' => 'number',
                ));
                ?>
                <div class="post-bottom">
                  <!-- Tags -->
                  <div class="post-tags">
                    <span><?php esc_html_e('Tag:', 'oryncart'); ?></span>
                    <?php
                    $post_tags = get_the_tags();
                    if ($post_tags) {
                      foreach ($post_tags as $tag) {
                        echo '<a href="' . esc_url(get_tag_link($tag->term_id)) . '" class="tags">' . esc_html($tag->name) . '</a>';
                      }
                    }
                    ?>
                  </div>
                  <!-- Social Share -->
                  <div class="social-share">
                    <span><?php esc_html_e('Share:', 'oryncart'); ?></span>
                    <div class="social-icons">
                      <a target="_blank" href="<?php echo esc_url('https://www.facebook.com/sharer.php?u=' . get_permalink()); ?>">
                        <i class="fa-brands fa-facebook-f"></i>
                      </a>
                      <a target="_blank" href="<?php echo esc_url('https://twitter.com/intent/tweet?text=' . rawurlencode(get_the_title()) . '&url=' . get_permalink()); ?>">
                        <i class="fa-brands fa-x-twitter"></i>
                      </a>
                      <a target="_blank" href="<?php echo esc_url('https://www.linkedin.com/shareArticle?mini=true&url=' . get_permalink() . '&title=' . rawurlencode(get_the_title())); ?>">
                        <i class="fa-brands fa-linkedin-in"></i>
                      </a>
                      <a target="_blank" href="<?php echo esc_url('https://www.youtube.com/results?search_query=' . rawurlencode(get_the_title())); ?>">
                        <i class="fa-brands fa-youtube"></i>
                      </a>
                    </div>
                  </div>
                </div>
              </div>
              <?php
              if (comments_open() || get_comments_number()) :
                comments_template();
              endif;
              ?>
            </div>
          <?php endwhile; ?>
        <?php else : ?>
          <p><?php esc_html_e('Sorry, no posts matched your criteria.', 'oryncart'); ?></p>
        <?php endif; ?>
        <!-- Sidebar Section -->
        <?php get_sidebar(); ?>
      </div>
    </div>
  </section>
</main>
<!-- End of Blog Post Section -->
<?php get_footer(); ?>