<?php get_header(); ?>
<?php get_template_part('inc/breadcrumb'); ?>
<!-- Start of Search Results Section -->
<main id="main-content" tabindex="-1">
    <section class="blog-page">
        <div class="container m-auto">
            <div class="row p-0">
                <?php
                if (have_posts()) :
                    while (have_posts()) : the_post();
                ?>
                        <div class="col-md-4">
                            <div class="blog-card">
                                <div class="blog-featured-image">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('medium'); ?></a>
                                    <?php endif; ?>
                                </div>
                                <div class="blog-meta">
                                    <div class="blog-author">
                                        <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                            <i class="fa-regular fa-user"></i>
                                            <span><?php the_author(); ?></span>
                                        </a>
                                    </div>
                                    <div class="blog-date">
                                        <a href="<?php echo esc_url(get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d'))); ?>">
                                            <i class="fa-regular fa-calendar-days"></i>
                                            <span><?php echo esc_html(get_the_date('j F, Y')); ?></span>
                                        </a>
                                    </div>
                                    <div class="blog-comments">
                                        <a href="<?php echo esc_url(get_comments_link()); ?>">
                                            <i class="fa-regular fa-comments"></i>
                                            <span>
                                                <?php comments_popup_link(esc_html__('Leave a comment', 'oryncart'), esc_html__('1 Comment', 'oryncart'), esc_html__('% Comments', 'oryncart')); ?>
                                            </span>
                                        </a>
                                    </div>
                                </div>
                                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                <a href="<?php the_permalink(); ?>" class="button-a"><?php esc_html_e('Read More', 'oryncart'); ?></a>
                            </div>
                        </div>
                <?php
                    endwhile;
                else :
                    echo '<p>' . esc_html__('No results found for your search.', 'oryncart') . '</p>';
                endif;
                ?>
            </div>
            <!-- Pagination -->
            <div class="pagination-wrap text-center mt-4">
                <?php
                echo paginate_links(array(
                    'total' => $wp_query->max_num_pages,
                    'current' => max(1, get_query_var('paged')),
                    'prev_text' => '<i class="fa-solid fa-chevron-left"></i>',
                    'next_text' => '<i class="fa-solid fa-chevron-right"></i>',
                    'type' => 'list',
                ));
                ?>
            </div>
        </div>
    </section>
</main>
<?php get_footer(); ?>