<?php get_header(); ?>
<?php get_template_part('inc/breadcrumb'); ?>
<!-- Start of Blog Section -->
<main id="main-content" tabindex="-1">
    <section class="blog-page">
        <div class="container m-auto">
            <div class="row p-0">
                <?php
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $args = array(
                    'post_type' => 'post',
                    'posts_per_page' => 9,
                    'paged' => $paged
                );
                $blog_query = new WP_Query($args);
                if ($blog_query->have_posts()) :
                    while ($blog_query->have_posts()) : $blog_query->the_post();
                ?>
                        <div class="col-md-4">
                            <div class="blog-card">
                                <div class="blog-featured-image">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('medium'); ?></a>
                                    <?php endif; ?>
                                </div>
                                <div class="blog-meta">
                                    <div class="blog-author">
                                        <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                            <i class="fa-regular fa-user"></i>
                                            <span><?php the_author(); ?></span>
                                        </a>
                                    </div>
                                    <div class="blog-date">
                                        <a href="<?php echo esc_url(get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d'))); ?>">
                                            <i class="fa-regular fa-calendar-days"></i>
                                            <span><?php echo esc_html(get_the_date('j F, Y')); ?></span></a>
                                    </div>
                                    <div class="blog-comments">
                                        <a href="<?php echo esc_url(get_comments_link()); ?>"><i class="fa-regular fa-comments"></i>
                                            <span>
                                                <?php comments_popup_link(esc_html__('Leave a comment', 'oryncart'), esc_html__('1 Comment', 'oryncart'), esc_html__('% Comments', 'oryncart')); ?>
                                            </span></a>
                                    </div>
                                </div>
                                    <h2 class="entry-title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h2>
                                <a href="<?php the_permalink(); ?>" class="button-a"><?php esc_html_e('Read More', 'oryncart'); ?></a>
                            </div>
                        </div>
                <?php
                    endwhile;
                    wp_reset_postdata();
                else :
                    echo '<p>' . esc_html__('No blog posts found.', 'oryncart') . '</p>';
                endif;
                ?>
            </div>
            <!-- Pagination -->
            <?php
            if (get_query_var('paged')) {
                $paged = get_query_var('paged');
            } else {
                $paged = 1;
            }
            $args = array(
                'post_type'      => 'post',
                'posts_per_page' => get_option('posts_per_page'), 
                'paged'          => $paged,
            );

            $blog_query = new WP_Query($args);
            ?>
            <div class="pagination-wrap text-center mt-4">
                <?php
                echo paginate_links(array(
                    'total'     => $blog_query->max_num_pages,
                    'current'   => $paged,
                    'prev_text' => '<i class="fa-solid fa-chevron-left"></i>',
                    'next_text' => '<i class="fa-solid fa-chevron-right"></i>',
                    'type'      => 'list',
                ));
                ?>
            </div>
        </div>
    </section>
</main>
<?php get_footer(); ?>