<?php
add_action('after_setup_theme', 'oryncart_theme_support');
if (! function_exists('oryncart_theme_support')) {
    function oryncart_theme_support()
    {
        // Register navigation menus
        register_nav_menus(array(
            'primary-menu'    => 'Primary Menu',
            'mobile-menu'     => 'Mobile Menu',
            'footer-menu'     => 'Footer Menu',
            'footer-menu-two' => 'Second Footer Menu'
        ));

        // Add post thumbnails
        add_theme_support('post-thumbnails');

        // Add title tag support
        add_theme_support('title-tag');

        // Add widgets support
        add_theme_support('widgets');

        // Remove widgets-block-editor support
        remove_theme_support('widgets-block-editor');

        // Add custom logo support
        add_theme_support('custom-logo');

        // Add title tag support (already added above, no need for duplication)
        add_theme_support('title-tag');
    }
}
// Theme Setup Functions
function oryncart_theme_setup()
{
    // Theme Supports
    add_theme_support('align-wide');
    add_theme_support('wp-block-styles');
    add_theme_support('responsive-embeds');
    add_theme_support('automatic-feed-links');
    add_theme_support('html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
    ));
    // Custom Header
    add_theme_support('custom-header', array(
        'width'         => 1200,
        'height'        => 400,
        'flex-width'    => true,
        'flex-height'   => true,
        'default-image' => get_template_directory_uri() . '/images/default-header.jpg',
    ));

    // Custom Background
    add_theme_support('custom-background', array(
        'default-color' => 'ffffff',
        'default-image' => '',
    ));
}
add_action('after_setup_theme', 'oryncart_theme_setup');
// Enqueue comment reply script
function oryncart_enqueue_comment_reply_script()
{
    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'oryncart_enqueue_comment_reply_script');
// Add editor styles
function oryncart_add_editor_styles()
{
    add_editor_style('editor-style.css');
}
add_action('admin_init', 'oryncart_add_editor_styles');
// Register custom block style
function oryncart_custom_block_styles()
{
    register_block_style(
        'core/paragraph',
        array(
            'name'  => 'oryncart-custom-style',
            'label' => __('Oryncart Custom Style', 'oryncart'),
        )
    );
}
add_action('init', 'oryncart_custom_block_styles');
// Register custom block pattern
function oryncart_custom_block_pattern()
{
    register_block_pattern(
        'oryncart/my-custom-pattern',
        array(
            'title'       => __('Oryncart Custom Pattern', 'oryncart'),
            'description' => __('A custom block pattern for oryncart theme.', 'oryncart'),
            'content'     => '<!-- wp:paragraph --><p>' . __('This is a custom pattern.', 'oryncart') . '</p><!-- /wp:paragraph -->',
        )
    );
}
add_action('init', 'oryncart_custom_block_pattern');
function oryncart_widgets_init()
{
    register_sidebar(array(
        'name'          => __('Right Sidebar', 'oryncart'),
        'id'            => 'right_sidebar',
        'description'   => __('Widgets for the right sidebar', 'oryncart'),
        'before_widget' => '<div class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));
}
add_action('widgets_init', 'oryncart_widgets_init');