<?php
class Oryncart_Mobile_Menu_Walker extends Walker_Nav_Menu
{
    // Start Level
    function start_lvl(&$output, $depth = 0, $args = array()) {
        $output .= '<ul class="m-sub-menu-l2">';
    }

    // End Level
    function end_lvl(&$output, $depth = 0, $args = array()) {
        $output .= '</ul>';
    }

    // Start Element
    function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
        $has_children = in_array('menu-item-has-children', $item->classes);

        $output .= '<li class="' . esc_attr(implode(' ', $item->classes)) . '">';

        $link_classes = [];
        if ($has_children) {
            $link_classes[] = 'm-sub-menu-l2-open';
        }
        if (in_array('current-menu-item', $item->classes)) {
            $link_classes[] = 'active';
        }

        $link_class_attr = !empty($link_classes) ? ' class="' . esc_attr(implode(' ', $link_classes)) . '"' : '';

        // -------------------------------
        // Parent link logic:
        // Submenu থাকলে link blank (onclick return false)
        // Submenu না থাকলে normal href
        // -------------------------------
        if ($has_children) {
            $output .= '<a' . $link_class_attr . ' href="' . esc_url($item->url) . '" onclick="return false;">';
        } else {
            $output .= '<a' . $link_class_attr . ' href="' . esc_url($item->url) . '">';
        }

        $output .= esc_html($item->title);

        if ($has_children) {
            if ($depth == 0) {
                $output .= ' <i class="fa-solid fa-chevron-down"></i>';
            } else {
                $output .= ' <i class="fa-solid fa-chevron-right"></i>';
            }
        }

        $output .= '</a>';
    }

    // End Element
    function end_el(&$output, $item, $depth = 0, $args = array()) {
        $output .= '</li>';
    }
}
