<?php
add_action('wp_enqueue_scripts', 'oryncart_enqueue_scripts');
if( !function_exists('oryncart_enqueue_scripts') ){
    function oryncart_enqueue_scripts(){
        $theme_uri = get_template_directory_uri();
        $version   = '1.0.0';

        /**
         * Enqueue 3rd-party styles
         */
        wp_enqueue_style( 'bootstrap', $theme_uri . '/css/bootstrap.css', array(), $version, 'all' );
        wp_enqueue_style( 'fontawesome', $theme_uri . '/css/fontawesome.min.css', array(), $version, 'all' );
        wp_enqueue_style( 'swiper', $theme_uri . '/css/swiper-bundle.min.css', array(), $version, 'all' );
        wp_enqueue_style( 'magnific-popup', $theme_uri . '/css/magnific-popup.css', array(), $version, 'all' );
        wp_enqueue_style( 'animate', $theme_uri . '/css/animate.min.css', array(), $version, 'all' );
        wp_enqueue_style( 'nice-select', $theme_uri . '/css/nice-select.css', array(), $version, 'all' );

        /**
         * Enqueue theme-specific styles
         */
        wp_enqueue_style( 'oryncart-spacing', $theme_uri . '/css/spacing.css', array(), $version, 'all' );
        wp_enqueue_style( 'oryncart-style', $theme_uri . '/css/style.css', array(), $version, 'all' );
        wp_enqueue_style( 'oryncart-responsive', $theme_uri . '/css/responsive.css', array(), $version, 'all' );
        wp_enqueue_style( 'oryncart-main', get_stylesheet_uri() );

        /**
         * Enqueue 3rd-party scripts
         * Note: jQuery dependency only, no direct enqueue from theme folder
         */
        wp_enqueue_script( 'bootstrap', $theme_uri . '/js/bootstrap.bundle.js', array('jquery'), $version, true );
        wp_enqueue_script( 'fontawesome', $theme_uri . '/js/fontawesome.min.js', array('jquery'), $version, true );
        wp_enqueue_script( 'swiper', $theme_uri . '/js/swiper-bundle.min.js', array('jquery'), $version, true );
        wp_enqueue_script( 'magnific-popup', $theme_uri . '/js/magnific-popup.min.js', array('jquery'), $version, true );
        wp_enqueue_script( 'counterup', $theme_uri . '/js/counterup.min.js', array('jquery'), $version, true );
        wp_enqueue_script( 'jquery-nice-select', $theme_uri . '/js/jquery.nice-select.min.js', array('jquery'), $version, true );

        /**
         * Enqueue theme-specific scripts
         */
        wp_enqueue_script( 'oryncart-plugins', $theme_uri . '/js/plugins.js', array('jquery'), $version, true );
        wp_enqueue_script( 'oryncart-script', $theme_uri . '/js/script.js', array('jquery'), $version, true );
    }
}
