<?php
function elementorconstruct_customizer($wp_customize)
{
    // Add Footer Panel
    $wp_customize->add_panel('footer_panel', array(
        'title'       => __('Footer Area', 'oryncart'),
        'description' => __('Customize Footer Top & Bottom', 'oryncart'),
        'priority'    => 5,
    ));
    // Add Footer Top Section
    $wp_customize->add_section('oryncart_footer_section', array(
        'title'       => __('Footer Top', 'oryncart'),
        'description' => __('Customize Footer From Here', 'oryncart'),
        'priority'    => 1,
        'panel'       => 'footer_panel',
    ));
    // Google Play Store Image
    $wp_customize->add_setting('oryncart_footer_logo_image', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control(
        $wp_customize,
        'oryncart_footer_logo_image',
        array(
            'label'    => __('Logo', 'oryncart'),
            'section'  => 'oryncart_footer_section',
            'settings' => 'oryncart_footer_logo_image',
        )
    ));
    // Google Play Store Image
    $wp_customize->add_setting('image_topper', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control(
        $wp_customize,
        'image_topper',
        array(
            'label'    => __('Google Play Image', 'oryncart'),
            'section'  => 'oryncart_footer_section',
            'settings' => 'image_topper',
        )
    ));
    // Apple App Store Image
    $wp_customize->add_setting('include_3', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control(
        $wp_customize,
        'include_3',
        array(
            'label'    => __('Apple App Store Image', 'oryncart'),
            'section'  => 'oryncart_footer_section',
            'settings' => 'include_3',
        )
    ));
    // Footer Tagline Setting
    $wp_customize->add_setting('oryncart_footer_tagline', array(
        'default'           => 'Lorem Ipsum Dolor.',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('oryncart_footer_tagline', array(
        'label'    => __('Tagline', 'oryncart'),
        'section'  => 'oryncart_footer_section',
        'type'     => 'text',
    ));
    $wp_customize->add_setting('footer_email_address', array(
        'default'           => 'support@example.com',
        'sanitize_callback' => 'sanitize_email',
        // No 'type' needed — defaults to 'theme_mod'
    ));
    $wp_customize->add_setting('footer_number_address', array(
        'default'           => '0190*****',
        'type'              => 'option',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('footer_number_address_control', array(
        'label'    => __('Footer Number', 'oryncart'),
        'section'  => 'oryncart_footer_section',
        'settings' => 'footer_number_address',
        'type'     => 'text',
    ));
    $wp_customize->add_control('footer_number_address_control', array(
        'label'    => __('Footer Number Address', 'oryncart'),
        'section'  => 'oryncart_footer_section',
        'settings' => 'footer_number_address',
    ));
    // Footer Tagline Setting
    $wp_customize->add_setting('oryncart_footer_tagline_title', array(
        'default'           => 'Title One',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('oryncart_footer_tagline_title', array(
        'label'    => __('Tagline', 'oryncart'),
        'section'  => 'oryncart_footer_section',
        'type'     => 'text',
    ));
    // Footer Tagline Setting
    $wp_customize->add_setting('oryncart_footer_tagline_dec', array(
        'default'           => 'Title Two',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('oryncart_footer_tagline_dec', array(
        'label'    => __('Tagline', 'oryncart'),
        'section'  => 'oryncart_footer_section',
        'type'     => 'text',
    ));
    // Footer Tagline Setting
    $wp_customize->add_setting('oryncart_footer_tagline_dec_two', array(
        'default'           => 'Title Three',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('oryncart_footer_tagline_dec_two', array(
        'label'    => __('Tagline', 'oryncart'),
        'section'  => 'oryncart_footer_section',
        'type'     => 'text',
    ));
    // Footer Tagline Setting
    $wp_customize->add_setting('oryncart_footer_tagline_two', array(
        'default'           => 'Lorem Ipsum Dolor.',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('oryncart_footer_tagline_two', array(
        'label'    => __('Tagline', 'oryncart'),
        'section'  => 'oryncart_footer_section',
        'type'     => 'text',
    ));
    // Add Footer Bottom Section
    $wp_customize->add_section('oryncart_footer_section_bootom', array(
        'title'       => __('Footer Bottom', 'oryncart'),
        'description' => __('Customize Footer Bottom Here', 'oryncart'),
        'priority'    => 1,
        'panel'       => 'footer_panel',
    ));
    // Footer Copy right Setting
    $wp_customize->add_setting('oryncart_footer_tagline_copyright', array(
        'default'           => 'Lorem Ipsum Dolor.',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('oryncart_footer_tagline_copyright', array(
        'label'    => __('Tagline', 'oryncart'),
        'section'  => 'oryncart_footer_section_bootom',
        'type'     => 'text',
    ));
    // Footer Copy Right Setting
    $wp_customize->add_setting('oryncart_footer_cprt', array(
        'default'           => 'Lorem Ipsum Dolor.',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('oryncart_footer_cprt', array(
        'label'    => __('Tagline', 'oryncart'),
        'section'  => 'oryncart_footer_section_bootom',
        'type'     => 'text',
    ));
    // Footer Copyright Author Link Setting
    $wp_customize->add_setting('oryncart_footer_cprt_link', array(
        'default'           => '#',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control('oryncart_footer_cprt_link', array(
        'label'    => __('Copyright Author Link', 'oryncart'),
        'section'  => 'oryncart_footer_section_bootom',
        'type'     => 'url',
    ));
    // Array of Image Settings
    $images = [
        'one'   => 'Footer Image One',
        'two'   => 'Footer Image Two',
        'three' => 'Footer Image Three',
        'four'  => 'Footer Image Four',
        'five'  => 'Footer Image Five',
    ];
    foreach ($images as $key => $label) {
        $setting_id = "oryncart_footer_logo_image_{$key}";

        $wp_customize->add_setting($setting_id, array(
            'default'           => '',
            'transport'         => 'postMessage',
            'sanitize_callback' => 'esc_url_raw',
        ));

        $wp_customize->add_control(new WP_Customize_Image_Control(
            $wp_customize,
            $setting_id,
            array(
                'label'    => $label, // Already translated above
                'section'  => 'oryncart_footer_section_bootom',
                'settings' => $setting_id,
            )
        ));
    }
}
add_action('customize_register', 'elementorconstruct_customizer');

function oryncart_header_textcolor_css() {
    $header_text_color = get_header_textcolor();

    if ( ! display_header_text() || $header_text_color === 'blank' ) {
        $css = "
            .site-title,
            .main-menu a,
            .site-header * {
                display: none;
            }
        ";
    } else {
        $css = "
            .site-title,
            .main-menu a,
            .site-header * {
                color: #". esc_attr($header_text_color) ." !important;
            }
        ";
    }

    echo "<style>{$css}</style>";
}
add_action('wp_head', 'oryncart_header_textcolor_css');