<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
    <a class="skip-link screen-reader-text" href="#main-content">
        <?php esc_html_e('Skip to content', 'oryncart'); ?>
    </a>
    <!-- Start of Header Section -->
    <!-- Main Header -->
    <!-- Search Box -->
    <?php get_search_form(); ?>
    <!-- Header One Markup -->
    <header class="header-section">
        <div class="container">
            <div class="row align-items-center main-header-v2">
                <!-- Logo -->
                <div class="col-xl-3 col-lg-3 col-md-2 col-5 p-0">
                    <div class="logo-v2">
                        <a href="<?php echo esc_url(home_url('/')); ?>">
                            <?php
                            $custom_logo_id = get_theme_mod('custom_logo');
                            $logo = wp_get_attachment_image_src($custom_logo_id, 'full');
                            if ($logo) :
                            ?>
                                <img src="<?php echo esc_url($logo[0]); ?>" alt="<?php bloginfo('name'); ?>">
                            <?php else : ?>
                                <h1 class="site-title" style="color:#<?php echo esc_attr(get_header_textcolor()); ?>">
                                    <?php bloginfo('name'); ?>
                                </h1>
                            <?php endif; ?>
                        </a>

                    </div>
                </div>
                <!-- Main Menu -->
                <div class="col-xl-6 col-lg-7 col-md-8 col-1 p-0">
                    <nav class="nav-links">
                        <?php
                        wp_nav_menu(array(
                            'theme_location' => 'primary-menu',
                            'menu_class'     => 'main-menu',
                            'fallback_cb'    => 'efc',
                            'walker'         => new WP_Bootstrap_Navwalker(),
                        ));
                        ?>
                    </nav>
                </div>
                <!-- Header Icons -->
                <div class="col-xl-3 col-lg-2 col-md-2 col-6 p-0">
                    <ul class="menu-right">
                        <li class="search-box-btn"><a href="#"><i class="fa-solid fa-magnifying-glass"></i></a></li>
                        <li><a href="#" class="mobile-menu-toggle"><i class="fa-solid fa-bars"></i></a></li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Mobile Menu -->
        <div class="mobile-menu">
            <div class="mobile-menu-logo">
                <div class="logo">
                    <?php
                    $custom_logo_id = get_theme_mod('custom_logo');
                    $logo = wp_get_attachment_image_src($custom_logo_id, 'full');
                    if ($logo) :
                    ?>
                        <img src="<?php echo esc_url($logo[0]); ?>" alt="<?php bloginfo('name'); ?>">
                    <?php else : ?>
                        <h1><?php bloginfo('name'); ?></h1>
                    <?php endif; ?>
                </div>
                <div class="mobile-menu-close">
                    <a href="#"><i class="fa-regular fa-circle-xmark"></i></a>
                </div>
            </div>
            <?php
            wp_nav_menu(array(
                'theme_location' => 'mobile-menu',
                'container'      => false,
                'items_wrap'     => '<ul>%3$s</ul>',
                'fallback_cb'    => 'efc',
                'walker'         => new Oryncart_Mobile_Menu_Walker(),
            ));
            ?>
        </div>
    </header>