<?php
$my_options = get_option('oryncart_options');
?>
<!-- Start of Footer Section -->
<footer class="footer-section">
    <div class="footer-top">
        <div class="container">
            <div class="row align-items-start">
                <div class="col-lg-3 col-sm-6">
                    <div class="footer-widget">
                        <div class="footer-about-brand">
                            <div class="footer-logo">
                                <?php
                                $website_name = get_bloginfo('name');
                                $image_url = get_theme_mod('oryncart_footer_logo_image');
                                if ($image_url) :
                                ?>
                                    <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($website_name); ?>">
                                <?php else : ?>
                                    <span style="color:#<?php echo esc_attr(get_header_textcolor()); ?>">
                                        <?php echo esc_html($website_name); ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <p><?php echo esc_html(get_theme_mod('oryncart_footer_tagline', 'Title Two')); ?></p>
                            <div class="email">
                                <i class="fa-solid fa-envelope"></i>
                                <span>
                                    <a>
                                        <?php echo esc_html(get_theme_mod('footer_email_address', 'support@example.com')); ?>
                                    </a>
                                </span>
                            </div>
                            <div class="phone">
                                <i class="fa-solid fa-phone"></i>
                                <span>
                                    <a>
                                        <?php echo esc_html(get_option('footer_number_address', '019126548')); ?>
                                    </a>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="footer-widget">
                        <h2><?php echo esc_html(get_theme_mod('oryncart_footer_tagline_title', 'Title One')); ?></h2>
                        <?php
                        wp_nav_menu(array(
                            'theme_location' => 'footer-menu-two',
                            'menu_class'     => 'footer-link',
                            'fallback_cb'    => 'efc',
                            'walker'         => new WP_Bootstrap_Navwalker(),
                        ));
                        ?>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="footer-widget">
                        <h2><?php echo esc_html(get_theme_mod('oryncart_footer_tagline_dec', 'Title Two')); ?></h2>
                        <?php
                        wp_nav_menu(array(
                            'theme_location' => 'footer-menu',
                            'menu_class'     => 'footer-link',
                            'fallback_cb'    => 'efc',
                            'walker'         => new WP_Bootstrap_Navwalker(),
                        ));
                        ?>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="footer-widget">
                        <h2><?php echo esc_html(get_theme_mod('oryncart_footer_tagline_dec_two', 'Title Three')); ?></h2>
                        <p><?php echo esc_html(get_theme_mod('oryncart_footer_tagline_two', 'Title Two')); ?></p>
                        <div class="download-app">
                            <div class="download-app">
                                <?php
                                // Get the theme mod values
                                $image_top    = get_theme_mod('image_topper');
                                $image_topper = get_theme_mod('include_3');
                                ?>

                                <!-- Google Play Store -->
                                <?php if ($image_top) : ?>
                                    <a target="_blank">
                                        <img src="<?php echo esc_url($image_top); ?>" alt="<?php esc_attr_e('Google Play Store', 'oryncart'); ?>">
                                    </a>
                                <?php endif; ?>

                                <!-- Apple App Store -->
                                <?php if ($image_topper) : ?>
                                    <a target="_blank">
                                        <img src="<?php echo esc_url($image_topper); ?>" alt="<?php esc_attr_e('Apple App Store', 'oryncart'); ?>">
                                    </a>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom">
        <div class="container">
            <div class="row">
                <?php
                $tagline      = get_theme_mod('oryncart_footer_tagline_copyright', 'Createn by');
                $author_name  = get_theme_mod('oryncart_footer_cprt', 'oryncart team');
                $author_link  = get_theme_mod('oryncart_footer_cprt_link', '#');
                ?>
                <div class="col-lg-6">
                    <div class="copyright">
                        <div>© <?php echo esc_html($tagline); ?>
                            <a href="<?php echo esc_url($author_link); ?>">
                                <?php echo esc_html($author_name); ?>
                            </a>
                        </div>
                    </div>
                </div>
                <?php
                // Get the theme mod values
                $image_one   = get_theme_mod('oryncart_footer_logo_image_one');
                $image_two   = get_theme_mod('oryncart_footer_logo_image_two');
                $image_three = get_theme_mod('oryncart_footer_logo_image_three');
                $image_four  = get_theme_mod('oryncart_footer_logo_image_four');
                $image_five  = get_theme_mod('oryncart_footer_logo_image_five');
                ?>

                <div class="col-lg-6">
                    <div class="payment-options">
                        <?php if ($image_one) : ?>
                            <img src="<?php echo esc_url($image_one); ?>" alt="<?php esc_attr_e('PayPal', 'oryncart'); ?>">
                        <?php endif; ?>

                        <?php if ($image_two) : ?>
                            <img src="<?php echo esc_url($image_two); ?>" alt="<?php esc_attr_e('Visa', 'oryncart'); ?>">
                        <?php endif; ?>

                        <?php if ($image_three) : ?>
                            <img src="<?php echo esc_url($image_three); ?>" alt="<?php esc_attr_e('Mastercard', 'oryncart'); ?>">
                        <?php endif; ?>

                        <?php if ($image_four) : ?>
                            <img src="<?php echo esc_url($image_four); ?>" alt="<?php esc_attr_e('JCB', 'oryncart'); ?>">
                        <?php endif; ?>

                        <?php if ($image_five) : ?>
                            <img src="<?php echo esc_url($image_five); ?>" alt="<?php esc_attr_e('Discover', 'oryncart'); ?>">
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
</footer>
<!-- End of Footer Section -->
<!-- Back to Top -->
<a href="javascript:" id="return-to-top"><i class="fa-solid fa-arrow-up-long"></i></a>
</body>
<?php wp_footer(); ?>

</html>