<?php
// Comment Form Fields
$fields = array(
    'author'  => '
        <div class="comment-input-area">
            <input class="form-control" name="author" id="name" placeholder="' . esc_attr__('Your Name', 'oryncart') . '" type="text" required>
            <input class="form-control" name="email" id="email" placeholder="' . esc_attr__('Your Email', 'oryncart') . '" type="email" required>
        </div>',
);
// Full Comment Form
$args = array(
    'class_submit'  => 'com-btn button-b',
    'label_submit'  => esc_html__('Submit Comment', 'oryncart'),
    'comment_field' => '
        <div class="comment-input-area">
            <label for="comment-box">
                <textarea class="form-control" name="comment" id="comment-box" placeholder="' . esc_attr__('Your Comment', 'oryncart') . '" rows="8" cols="180" required></textarea>
            </label>
        </div>',
    'fields'        => apply_filters('comment_form_default_fields', $fields),
);

comment_form($args);
?>
<!-- Comment List -->
<div class="commented-section tab-content">
    <?php if (post_password_required()) return; ?>

    <style>
        ul.review-wrap>li.comment ul.children {
            margin-left: 70px;
            list-style: none;
            padding-left: 0;
        }
    </style>
    <div id="comments" class="comments-area">
        <?php if (have_comments()) : ?>
            <h3 class="comments-heading">
                <?php
                printf(
                    esc_html(_nx('%s comment', '%s comments', get_comments_number(), 'Comments title', 'oryncart')),
                    esc_html(number_format_i18n(get_comments_number()))
                );
                ?>
            </h3>
            <!-- Comment Pagination -->
            <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
                <nav class="comment-navigation">
                    <div class="nav-previous"><?php previous_comments_link(esc_html__('Older Comments', 'oryncart')); ?></div>
                    <div class="nav-next"><?php next_comments_link(esc_html__('Newer Comments', 'oryncart')); ?></div>
                </nav>
            <?php endif; ?>
            <!-- Comment Loop -->
            <ul class="review-wrap">
                <?php
                wp_list_comments(array(
                    'style'      => 'ul',
                    'short_ping' => true,
                    'avatar_size' => 84,
                    'format'     => 'html5',
                ));
                ?>
            </ul>
            <!-- Repeated Pagination -->
            <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
                <nav class="comment-navigation">
                    <div class="nav-previous"><?php previous_comments_link(esc_html__('Older Comments', 'oryncart')); ?></div>
                    <div class="nav-next"><?php next_comments_link(esc_html__('Newer Comments', 'oryncart')); ?></div>
                </nav>
            <?php endif; ?>
        <?php endif; ?>
        <?php if (! comments_open()) : ?>
            <h3 class="comments-heading"><?php esc_html_e('Comments are closed.', 'oryncart'); ?></h3>
        <?php endif; ?>
    </div>
</div>