<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @package Oryncart
 */
get_header();
get_template_part('inc/breadcrumb');
?>
<div class="custom-404-container">
    <div class="custom-404" role="region" aria-labelledby="page-not-found-title">
        <h1><?php esc_html_e('404', 'oryncart'); ?></h1>
        <h2 id="page-not-found-title"><?php esc_html_e('Page Not Found', 'oryncart'); ?></h2>
        <p><?php esc_html_e('Sorry, the page you are looking for doesn’t exist or has been moved.', 'oryncart'); ?></p>
        <a href="<?php echo esc_url(home_url('/')); ?>" class="button">
            <?php esc_html_e('← Go to Homepage', 'oryncart'); ?>
        </a>
    </div>
</div>

<?php
get_footer();
