<?php
/**
 * Help Panel.
 *
 * @package Organic_Gardening
 */
?>

<div id="help-panel" class="panel-left visible">

    <div class="panel-aside active">
        <h4><?php printf( esc_html__( ' DEMO CONTENT IMPORTER', 'organic-gardening' )); ?></h4>
        <p><?php esc_html_e( 'Your journey to a powerful and stylish website begins here. Let’s get everything set up in just a few clicks!', 'organic-gardening' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url(admin_url('themes.php?page=organicgardening-wizard')); ?>" title="<?php esc_attr_e( 'Demo Importer', 'organic-gardening' ); ?>" target="_blank">
            <?php esc_html_e( 'DEMO IMPORTER', 'organic-gardening' ); ?>
        </a>
    </div>

    <div class="panel-aside">
        <h4><?php printf( esc_html__( ' VISIT FREE DOCUMENTATION', 'organic-gardening' )); ?></h4>
        <p><?php esc_html_e( 'Are you a newcomer to the WordPress universe? Our comprehensive and user-friendly documentation guide is designed to assist you in effortlessly building a captivating and interactive website, even if you lack any coding expertise or prior experience. Follow our step-by-step instructions to create a visually appealing and engaging online presence.', 'organic-gardening' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( ORGANIC_GARDENING_FREE_DOC_URL ); ?>" title="<?php esc_attr_e( 'Visit the Documentation', 'organic-gardening' ); ?>" target="_blank">
            <?php esc_html_e( 'FREE DOCUMENTATION', 'organic-gardening' ); ?>
        </a>
    </div>

    <div class="panel-aside " >
        <h4><?php esc_html_e( 'REVIEW', 'organic-gardening' ); ?></h4>
        <p><?php esc_html_e( 'If you are passionate about the Organic Gardening theme, we would love to hear your thoughts and feedback regarding our theme. Your review will be highly valuable to us as we strive to enhance and improve our theme based on the needs and preferences of our users. Your opinion matters, and we sincerely appreciate your time and effort in sharing your experience with the Organic Gardening theme.', 'organic-gardening' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( ORGANIC_GARDENING_REVIEW_URL ); ?>" title="<?php esc_attr_e( 'Visit the Review', 'organic-gardening' ); ?>" target="_blank">
            <?php esc_html_e( 'REVIEW', 'organic-gardening' ); ?>
        </a>
    </div>
    
    <div class="panel-aside">
        <h4><?php esc_html_e( 'CONTACT SUPPORT', 'organic-gardening' ); ?></h4>
        <p>
            <?php esc_html_e( 'Thank you for choosing Organic Gardening! We appreciate your interest in our theme and are here to assist you with any support you may need.', 'organic-gardening' ); ?></p>
        <a class="button button-primary" href="<?php echo esc_url( ORGANIC_GARDENING_SUPPORT_URL ); ?>" title="<?php esc_attr_e( 'Visit the Support', 'organic-gardening' ); ?>" target="_blank">
            <?php esc_html_e( 'CONTACT SUPPORT', 'organic-gardening' ); ?>
        </a>
    </div>

    
</div>