<?php
/**
 * Organic Gardening Theme Customizer.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package organic_gardening
 */

if( ! function_exists( 'organic_gardening_customize_register' ) ):  
/**
 * Add postMessage support for site title and description for the Theme Customizer.F
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function organic_gardening_customize_register( $wp_customize ) {
    require get_parent_theme_file_path('/inc/controls/changeable-icon.php');

    require get_parent_theme_file_path('/inc/controls/sortable-control.php');

    //Register the sortable control type.
    $wp_customize->register_control_type( 'Organic_Gardening_Control_Sortable' ); 

    if ( version_compare( get_bloginfo('version'),'4.9', '>=') ) {
        $wp_customize->get_section( 'static_front_page' )->title = __( 'Static Front Page', 'organic-gardening' );
    }
	
    /* Option list of all post */	
    $organic_gardening_options_posts = array();
    $organic_gardening_options_posts_obj = get_posts('posts_per_page=-1');
    $organic_gardening_options_posts[''] = esc_html__( 'Choose Post', 'organic-gardening' );
    foreach ( $organic_gardening_options_posts_obj as $organic_gardening_posts ) {
    	$organic_gardening_options_posts[$organic_gardening_posts->ID] = $organic_gardening_posts->post_title;
    }
    
    /* Option list of all categories */
    $organic_gardening_args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $organic_gardening_option_categories = array();
    $organic_gardening_category_lists = get_categories( $organic_gardening_args );
    $organic_gardening_option_categories[''] = esc_html__( 'Choose Category', 'organic-gardening' );
    foreach( $organic_gardening_category_lists as $organic_gardening_category ){
        $organic_gardening_option_categories[$organic_gardening_category->term_id] = $organic_gardening_category->name;
    }
    
    /** Default Settings */    
    $wp_customize->add_panel( 
        'wp_default_panel',
         array(
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__( 'Default Settings', 'organic-gardening' ),
            'description' => esc_html__( 'Default section provided by wordpress customizer.', 'organic-gardening' ),
        ) 
    );
    
    $wp_customize->get_section( 'title_tagline' )->panel                  = 'wp_default_panel';
    $wp_customize->get_section( 'colors' )->panel                         = 'wp_default_panel';
    $wp_customize->get_section( 'header_image' )->panel                   = 'wp_default_panel';
    $wp_customize->get_section( 'background_image' )->panel               = 'wp_default_panel';
    $wp_customize->get_section( 'static_front_page' )->panel              = 'wp_default_panel';
    
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    
    /** Default Settings Ends */
    
    /** Site Title control */
    $wp_customize->add_setting( 
        'header_site_title', 
        array(
            'default'           => true,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_site_title',
        array(
            'label'       => __( 'Show / Hide Site Title', 'organic-gardening' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    /** Tagline control */
    $wp_customize->add_setting( 
        'header_tagline', 
        array(
            'default'           => false,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_tagline',
        array(
            'label'       => __( 'Show / Hide Tagline', 'organic-gardening' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('logo_width', array(
        'sanitize_callback' => 'absint', 
    ));

    // Add a control for logo width
    $wp_customize->add_control('logo_width', array(
        'label' => __('Logo Width', 'organic-gardening'),
        'section' => 'title_tagline',
        'type' => 'number',
        'input_attrs' => array(
            'min' => '50', 
            'max' => '500', 
            'step' => '5', 
    ),
        'default' => '100', 
    ));

    $wp_customize->add_setting( 'organic_gardening_site_title_size', array(
        'default'           => 30, // Default font size in pixels
        'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
    ) );

    // Add control for site title size
    $wp_customize->add_control( 'organic_gardening_site_title_size', array(
        'type'        => 'number',
        'section'     => 'title_tagline', // You can change this section to your preferred section
        'label'       => __( 'Site Title Font Size (px)', 'organic-gardening' ),
        'input_attrs' => array(
            'min'  => 10,
            'max'  => 100,
            'step' => 1,
        ),
    ) );

    /** Responsive Media settings */
    
    $wp_customize->add_section(
        'organic_gardening_responsive_media_section',
        array(
            'title' => esc_html__( 'Responsive Media Settings', 'organic-gardening' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'organic_gardening_general_settings',
        )
    );

    /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'organic_gardening_resp_scroll_top', 
        array(
            'default' => 1,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_resp_scroll_top',
        array(
            'label'       => __( 'Show Scroll To Top', 'organic-gardening' ),
            'section'     => 'organic_gardening_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

        /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'organic_gardening_resp_loader', 
        array(
            'default' => 0,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_resp_loader',
        array(
            'label'       => __( 'Show Preloader', 'organic-gardening' ),
            'section'     => 'organic_gardening_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

    /** Responsive Media Ends */

    //Global Color
    $wp_customize->add_section(
        'organic_gardening_global_color',
        array(
            'title' => esc_html__( 'Global Color Settings', 'organic-gardening' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'organic_gardening_general_settings',
        )
    );

    $wp_customize->add_setting('organic_gardening_primary_color', array(
        'default'           => '#0B3D2C',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'organic_gardening_primary_color', array(
        'label'    => __('Theme Primary Color', 'organic-gardening'),
        'section'  => 'organic_gardening_global_color',
        'settings' => 'organic_gardening_primary_color',
    )));    

    /** Post & Pages Settings */
    $wp_customize->add_panel( 
        'organic_gardening_post_settings',
         array(
            'priority' => 12,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Post & Pages Settings', 'organic-gardening' ),
            'description' => esc_html__( 'Customize Post & Pages Settings', 'organic-gardening' ),
        ) 
    );

        /** Post Layouts */
    
    $wp_customize->add_section(
        'organic_gardening_post_layout_section',
        array(
            'title' => esc_html__( 'Post Layout Settings', 'organic-gardening' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'organic_gardening_post_settings',
        )
    );

    $wp_customize->add_setting('organic_gardening_post_layout_setting', array(
        'default'           => 'right-sidebar',
        'sanitize_callback' => 'organic_gardening_sanitize_post_layout',
    ));

    $wp_customize->add_control('organic_gardening_post_layout_setting', array(
        'label'    => __('Post Column Settings', 'organic-gardening'),
        'section'  => 'organic_gardening_post_layout_section',
        'settings' => 'organic_gardening_post_layout_setting',
        'type'     => 'select',
        'choices'  => array(
            'one-column'   => __('One Column', 'organic-gardening'),
            'right-sidebar'   => __('Right Sidebar', 'organic-gardening'),
            'left-sidebar'   => __('Left Sidebar', 'organic-gardening'),
            'three-column'   => __('Three Columns', 'organic-gardening'),
            'four-column'   => __('Four Columns', 'organic-gardening'),
        ),
    ));

    $wp_customize->add_setting('organic_gardening_archive_pagination_alignment',array(
        'default' => 'left-align',
        'sanitize_callback' => 'organic_gardening_sanitize_pagination_alignment'
    ));
    $wp_customize->add_control('organic_gardening_archive_pagination_alignment',array(
        'type' => 'select',
        'label' => __('Pagination Alignment','organic-gardening'),
        'section' => 'organic_gardening_post_layout_section',
        'choices' => array(
            'right-align' => __('Right Alignment','organic-gardening'),
            'center-align' => __('Center Alignment','organic-gardening'),
            'left-align' => __('Left Alignment','organic-gardening'),
        ),
    ) );

     /** Post Layouts Ends */
     
    /** Post Settings */
    $wp_customize->add_section(
        'organic_gardening_post_settings',
        array(
            'title' => esc_html__( 'Post Settings', 'organic-gardening' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'organic_gardening_post_settings',
        )
    );

    /** Post Heading control */
    $wp_customize->add_setting( 
        'organic_gardening_post_heading_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_post_heading_setting',
        array(
            'label'       => __( 'Show / Hide Post Heading', 'organic-gardening' ),
            'section'     => 'organic_gardening_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Meta control */
    $wp_customize->add_setting( 
        'organic_gardening_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Post Meta', 'organic-gardening' ),
            'section'     => 'organic_gardening_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Image control */
    $wp_customize->add_setting( 
        'organic_gardening_post_image_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_post_image_setting',
        array(
            'label'       => __( 'Show / Hide Post Image', 'organic-gardening' ),
            'section'     => 'organic_gardening_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Content control */
    $wp_customize->add_setting( 
        'organic_gardening_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Post Content', 'organic-gardening' ),
            'section'     => 'organic_gardening_post_settings',
            'type'        => 'checkbox',
        )
    );
    /** Post ReadMore control */
     $wp_customize->add_setting( 'organic_gardening_read_more_setting', array(
        'default'           => true,
        'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
    ) );

    $wp_customize->add_control( 'organic_gardening_read_more_setting', array(
        'type'        => 'checkbox',
        'section'     => 'organic_gardening_post_settings', 
        'label'       => __( 'Display Read More Button', 'organic-gardening' ),
    ) );

    $wp_customize->add_setting('organic_gardening_blog_meta_order', array(
        'default' => array('heading', 'author', 'featured-image', 'content','button'),
        'sanitize_callback' => 'organic_gardening_sanitize_sortable',
    ));
    $wp_customize->add_control(new Organic_Gardening_Control_Sortable($wp_customize, 'organic_gardening_blog_meta_order', array(
        'label' => esc_html__('Post Meta Ordering', 'organic-gardening'),
        'description' => __('Drag & drop post items to rearrange the ordering ( this control will not function by post format )', 'organic-gardening') ,
        'section' => 'organic_gardening_post_settings',
        'choices' => array(
            'heading' => __('heading', 'organic-gardening') ,
            'author' => __('author', 'organic-gardening') ,
            'featured-image' => __('featured-image', 'organic-gardening') ,
            'content' => __('content', 'organic-gardening') ,
            'button' => __('button', 'organic-gardening') ,
        ) ,
    )));

    /** Post Settings Ends */

     /** Single Post Settings */
    $wp_customize->add_section(
        'organic_gardening_single_post_settings',
        array(
            'title' => esc_html__( 'Single Post Settings', 'organic-gardening' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'organic_gardening_post_settings',
        )
    );

    /** Single Post Meta control */
    $wp_customize->add_setting( 
        'organic_gardening_single_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_single_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Meta', 'organic-gardening' ),
            'section'     => 'organic_gardening_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Content control */
    $wp_customize->add_setting( 
        'organic_gardening_single_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_single_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Content', 'organic-gardening' ),
            'section'     => 'organic_gardening_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Settings Ends */

         // Typography Settings Section
    $wp_customize->add_section('organic_gardening_typography_settings', array(
        'title'      => esc_html__('Typography Settings', 'organic-gardening'),
        'priority'   => 30,
        'capability' => 'edit_theme_options',
        'panel' => 'organic_gardening_general_settings',
    ));

    // Array of fonts to choose from
    $font_choices = array(
        ''               => __('Select', 'organic-gardening'),
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
        'Libre Baskerville' => 'Libre Baskerville',
    );

    // Heading Font Setting
    $wp_customize->add_setting('organic_gardening_heading_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'organic_gardening_sanitize_choicess',
    ));
    $wp_customize->add_control('organic_gardening_heading_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Heading', 'organic-gardening'),
        'section' => 'organic_gardening_typography_settings',
    ));

    // Body Font Setting
    $wp_customize->add_setting('organic_gardening_body_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'organic_gardening_sanitize_choicess',
    ));
    $wp_customize->add_control('organic_gardening_body_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Body', 'organic-gardening'),
        'section' => 'organic_gardening_typography_settings',
    ));

    /** Typography Settings Section End */

    /** General Settings */
    $wp_customize->add_panel( 
        'organic_gardening_general_settings',
         array(
            'priority' => 12,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'General Settings', 'organic-gardening' ),
            'description' => esc_html__( 'Customize General Settings', 'organic-gardening' ),
        ) 
    );


    /** General Settings */
    $wp_customize->add_section(
        'organic_gardening_general_settings',
        array(
            'title' => esc_html__( 'Loader Settings', 'organic-gardening' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'organic_gardening_general_settings',
        )
    );

    /** Preloader control */
    $wp_customize->add_setting( 
        'organic_gardening_header_preloader', 
        array(
            'default' => false,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_header_preloader',
        array(
            'label'       => __( 'Show Preloader', 'organic-gardening' ),
            'section'     => 'organic_gardening_general_settings',
            'type'        => 'checkbox',
        )
    );

    /** Header Section Settings */
    $wp_customize->add_section(
        'organic_gardening_header_section_settings',
        array(
            'title' => esc_html__( 'Header Section Settings', 'organic-gardening' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'organic_gardening_home_page_settings',
        )
    );

      /** Phone */
    $wp_customize->add_setting(
        'organic_gardening_header_phone',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'organic_gardening_header_phone',
        array(
            'label' => esc_html__( 'Add Phone', 'organic-gardening' ),
            'section' => 'organic_gardening_header_section_settings',
            'type' => 'text',
        )
    );


     /** Email */
    $wp_customize->add_setting(
        'organic_gardening_header_email',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'organic_gardening_header_email',
        array(
            'label' => esc_html__( 'Add Mail Address', 'organic-gardening' ),
            'section' => 'organic_gardening_header_section_settings',
            'type' => 'text',
        )
    );

        /** Sign Up Button */
    $wp_customize->add_setting(
        'organic_gardening_header_btn_text',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'organic_gardening_header_btn_text',
        array(
            'label' => esc_html__( 'Add Button Text', 'organic-gardening' ),
            'section' => 'organic_gardening_header_section_settings',
            'type' => 'text',
        )
    );

    /** Appointment Button */
    $wp_customize->add_setting(
        'organic_gardening_header_btn_url',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'organic_gardening_header_btn_url',
        array(
            'label' => esc_html__( 'Add Button URL', 'organic-gardening' ),
            'section' => 'organic_gardening_header_section_settings',
            'type' => 'url',
        )
    );

    /** Sticky Header control */
    $wp_customize->add_setting( 
        'organic_gardening_sticky_header', 
        array(
            'default' => false,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_sticky_header',
        array(
            'label'       => __( 'Show Sticky Header', 'organic-gardening' ),
            'section'     => 'organic_gardening_header_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Add Setting for Menu Font Weight
    $wp_customize->add_setting( 'organic_gardening_menu_font_weight', array(
        'default'           => 'Bold',
        'sanitize_callback' => 'organic_gardening_sanitize_font_weight',
    ) );

    // Add Control for Menu Font Weight
    $wp_customize->add_control( 'organic_gardening_menu_font_weight', array(
        'label'    => __( 'Menu Font Weight', 'organic-gardening' ),
        'section'  => 'organic_gardening_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            '100' => __( '100 - Thin', 'organic-gardening' ),
            '200' => __( '200 - Extra Light', 'organic-gardening' ),
            '300' => __( '300 - Light', 'organic-gardening' ),
            '400' => __( '400 - Normal', 'organic-gardening' ),
            '500' => __( '500 - Medium', 'organic-gardening' ),
            '600' => __( '600 - Semi Bold', 'organic-gardening' ),
            '700' => __( '700 - Bold', 'organic-gardening' ),
            '800' => __( '800 - Extra Bold', 'organic-gardening' ),
            '900' => __( '900 - Black', 'organic-gardening' ),
        ),
    ) );

    // Add Setting for Menu Text Transform
    $wp_customize->add_setting( 'organic_gardening_menu_text_transform', array(
        'default'           => 'Capitalize',
        'sanitize_callback' => 'organic_gardening_sanitize_text_transform',
    ) );

    // Add Control for Menu Text Transform
    $wp_customize->add_control( 'organic_gardening_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'organic-gardening' ),
        'section'  => 'organic_gardening_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            'none'       => __( 'None', 'organic-gardening' ),
            'capitalize' => __( 'Capitalize', 'organic-gardening' ),
            'uppercase'  => __( 'Uppercase', 'organic-gardening' ),
            'lowercase'  => __( 'Lowercase', 'organic-gardening' ),
        ),
    ) );

    $wp_customize->add_setting('organic_gardening_menus_style',array(
        'default' => '',
        'sanitize_callback' => 'organic_gardening_sanitize_choices'
	));
	$wp_customize->add_control('organic_gardening_menus_style',array(
        'type' => 'select',
		'label' => __('Menu Hover Style','organic-gardening'),
		'section' => 'organic_gardening_header_section_settings',
		'choices' => array(
         'None' => __('None','organic-gardening'),
         'Zoom In' => __('Zoom In','organic-gardening'),
      ),
	));

    /** Socail Section Settings */
    $wp_customize->add_section(
        'organic_gardening_social_section_settings',
        array(
            'title' => esc_html__( 'Social Media Section Settings', 'organic-gardening' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'organic_gardening_home_page_settings',
        )
    );

    /** Socail Section control */
    $wp_customize->add_setting( 
        'organic_gardening_social_icon_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_social_icon_setting',
        array(
            'label'       => __( 'Show Social Icon', 'organic-gardening' ),
            'section'     => 'organic_gardening_social_section_settings',
            'type'        => 'checkbox',
        )
    );

    /**  Social Link 1 */
    $wp_customize->add_setting(
        'organic_gardening_social_link_1',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'organic_gardening_social_link_1',
        array(
            'label' => esc_html__( 'Add Facebook Link', 'organic-gardening' ),
            'section' => 'organic_gardening_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 2 */
    $wp_customize->add_setting(
        'organic_gardening_social_link_2',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'organic_gardening_social_link_2',
        array(
            'label' => esc_html__( 'Add Twitter Link', 'organic-gardening' ),
            'section' => 'organic_gardening_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 3 */
    $wp_customize->add_setting(
        'organic_gardening_social_link_3',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'organic_gardening_social_link_3',
        array(
            'label' => esc_html__( 'Add Instagram Link', 'organic-gardening' ),
            'section' => 'organic_gardening_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 4 */
    $wp_customize->add_setting(
        'organic_gardening_social_link_4',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'organic_gardening_social_link_4',
        array(
            'label' => esc_html__( 'Add Pintrest Link', 'organic-gardening' ),
            'section' => 'organic_gardening_social_section_settings',
            'type' => 'url',
        )
    );

    /** Social Section Settings End */


    /** Home Page Settings */
    $wp_customize->add_panel( 
        'organic_gardening_home_page_settings',
         array(
            'priority' => 9,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Home Page Settings', 'organic-gardening' ),
            'description' => esc_html__( 'Customize Home Page Settings', 'organic-gardening' ),
        ) 
    );

    /** Slider Section Settings */
    $wp_customize->add_section(
        'organic_gardening_slider_section_settings',
        array(
            'title' => esc_html__( 'Slider Section Settings', 'organic-gardening' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'organic_gardening_home_page_settings',
        )
    );

    /** Slider Section control */
    $wp_customize->add_setting( 
        'organic_gardening_slider_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_slider_setting',
        array(
            'label'       => __( 'Show Slider', 'organic-gardening' ),
            'section'     => 'organic_gardening_slider_section_settings',
            'type'        => 'checkbox',
        )
    );
    
    $categories = get_categories();
        $cat_posts = array();
            $i = 0;
            $cat_posts[]='Select';
        foreach($categories as $category){
            if($i==0){
            $default = $category->slug;
            $i++;
        }
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
        'organic_gardening_blog_slide_category',
        array(
            'default'   => 'select',
            'sanitize_callback' => 'organic_gardening_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'organic_gardening_blog_slide_category',
        array(
            'type'    => 'select',
            'choices' => $cat_posts,
            'label' => __('Select Category to display Slides','organic-gardening'),
            'section' => 'organic_gardening_slider_section_settings',
        )
    );

    // slider button 1
    $wp_customize->add_setting('organic_gardening_slider_second_button_url', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('organic_gardening_slider_second_button_url', 
        array(
        'label'       => __('Slider First Button URL', 'organic-gardening'),
        'section'     => 'organic_gardening_slider_section_settings',   
        'settings'    => 'organic_gardening_slider_second_button_url',
        'type'        => 'url'
        )
    );

        /** Classes Section Settings */
    $wp_customize->add_section(
        'organic_gardening_classes_section_settings',
        array(
            'title' => esc_html__( 'Services Section Settings', 'organic-gardening' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'organic_gardening_home_page_settings',
        )
    );

    /** Classes Section control */
    $wp_customize->add_setting( 
        'organic_gardening_classes_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_classes_setting',
        array(
            'label'       => __( 'Show Services Section', 'organic-gardening' ),
            'section'     => 'organic_gardening_classes_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Section Title
    $wp_customize->add_setting(
        'organic_gardening_service_title', 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'organic_gardening_service_title', 
        array(
            'label'       => __('Section Title', 'organic-gardening'),
            'section'     => 'organic_gardening_classes_section_settings',
            'settings'    => 'organic_gardening_service_title',
            'type'        => 'text'
        )
    );

     // Section Text
    $wp_customize->add_setting(
        'organic_gardening_service_text', 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'organic_gardening_service_text', 
        array(
            'label'       => __('Section Text', 'organic-gardening'),
            'section'     => 'organic_gardening_classes_section_settings',
            'settings'    => 'organic_gardening_service_text',
            'type'        => 'text'
        )
    );

    // Post Categories
    $categories = get_categories();
    $cat_posts = array();
    $default = '';
    $cat_posts[] = 'Select';
    foreach ($categories as $category) {
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
        'organic_gardening_blog_args_',
        array(
            'default'            => 'select',
            'sanitize_callback'  => 'organic_gardening_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'organic_gardening_blog_args_',
        array(
            'type'     => 'select',
            'choices'  => $cat_posts,
            'label'    => __('Select Category to Display Services', 'organic-gardening'),
            'section'  => 'organic_gardening_classes_section_settings',
        )
    );

    $wp_customize->add_setting('organic_gardening_about_points',array(
        'default'   => '4',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('organic_gardening_about_points',array(
        'label' => __('Add number of points','organic-gardening'),
        'section'   => 'organic_gardening_classes_section_settings',
        'type'      => 'number',
        'input_attrs' => array(
        'min' => 1,     
        'max' => 4
        )
    ));
    $organic_gardening_about_point = get_theme_mod('organic_gardening_about_points','');
     for ( $m = 1; $m <= $organic_gardening_about_point; $m++ ){
        $wp_customize->add_setting('organic_gardening_about_points_text'.$m,array(
            'default'   => '',
            'sanitize_callback' => 'sanitize_text_field'
        ));
        $wp_customize->add_control('organic_gardening_about_points_text'.$m,array(
            'label' => __('Add Text ','organic-gardening').$m,
            'section'   => 'organic_gardening_classes_section_settings',
            'type'      => 'text'
        ));
}

    // service button 1
    $wp_customize->add_setting('organic_gardening_service_button_url', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('organic_gardening_service_button_url', 
        array(
        'label'       => __('Service Button URL', 'organic-gardening'),
        'section'     => 'organic_gardening_classes_section_settings',   
        'settings'    => 'organic_gardening_service_button_url',
        'type'        => 'url'
        )
    );


    for ($i=1; $i <= 8; $i++) {

    $wp_customize->add_setting('organic_gardening_category_icon'.$i,array(
        'default'   => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Organic_Gardening_Changeable_Icon(
        $wp_customize,'organic_gardening_category_icon'.$i,array(
        'label' => __('Feature Icon ','organic-gardening').$i,
        'transport' => 'refresh',
        'section'   => 'organic_gardening_classes_section_settings',
        'type'      => 'icon'
    )));
}
    
    
    /** Home Page Settings Ends */
    
    /** Footer Section */
    $wp_customize->add_section(
        'organic_gardening_footer_section',
        array(
            'title' => __( 'Footer Settings', 'organic-gardening' ),
            'priority' => 70,
            'panel' => 'organic_gardening_home_page_settings',
        )
    );

    /** Footer Copyright control */
    $wp_customize->add_setting( 
        'organic_gardening_footer_setting', 
        array(
            'default' => true,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_footer_setting',
        array(
            'label'       => __( 'Show Footer Copyright', 'organic-gardening' ),
            'section'     => 'organic_gardening_footer_section',
            'type'        => 'checkbox',
        )
    );
    
    /** Copyright Text */
    $wp_customize->add_setting(
        'organic_gardening_footer_copyright_text',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'organic_gardening_footer_copyright_text',
        array(
            'label' => __( 'Copyright Info', 'organic-gardening' ),
            'section' => 'organic_gardening_footer_section',
            'type' => 'text',
        )
    );  
$wp_customize->add_setting('organic_gardening_footer_background_image',
        array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
        )
    );


    $wp_customize->add_control(
         new WP_Customize_Cropped_Image_Control($wp_customize, 'organic_gardening_footer_background_image',
            array(
                'label' => esc_html__('Footer Background Image', 'organic-gardening'),
                'description' => sprintf(esc_html__('Recommended Size %1$s px X %2$s px', 'organic-gardening'), 1024, 800),
                'section' => 'organic_gardening_footer_section',
                'width' => 1024,
                'height' => 800,
                'flex_width' => true,
                'flex_height' => true,
            )
        )
    );

    /** Footer Background Image Attachment */
    $wp_customize->add_setting('organic_gardening_background_attatchment', array(
        'default'           => 'scroll',
        'sanitize_callback' => 'organic_gardening_sanitize_choices',
    ));

    $wp_customize->add_control('organic_gardening_background_attatchment', array(
        'label'    => __('Footer Background Attachment', 'organic-gardening'),
        'section'  => 'organic_gardening_footer_section',
        'settings' => 'organic_gardening_background_attatchment',
        'type'     => 'select',
        'choices'  => array(
            'fixed' => __('fixed','organic-gardening'),
            'scroll' => __('scroll','organic-gardening'),
        ),
    ));

    /* Footer Background Color*/
    $wp_customize->add_setting(
        'organic_gardening_footer_background_color',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'organic_gardening_footer_background_color',
            array(
                'label' => __('Footer Widget Area Background Color', 'organic-gardening'),
                'section' => 'organic_gardening_footer_section',
                'type' => 'color',
            )
        )
    );

    /** Scroll to top control */
    $wp_customize->add_setting( 
        'organic_gardening_scroll_to_top', 
        array(
            'default' => 1,
            'sanitize_callback' => 'organic_gardening_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'organic_gardening_scroll_to_top',
        array(
            'label'       => __( 'Show Scroll To Top', 'organic-gardening' ),
            'section'     => 'organic_gardening_footer_section',
            'type'        => 'checkbox',
        )
    );

     $wp_customize->add_setting('organic_gardening_scroll_icon',array(
        'default'   => 'fas fa-arrow-up',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Organic_Gardening_Changeable_Icon(
        $wp_customize,'organic_gardening_scroll_icon',array(
        'label' => __('Scroll Top Icon','organic-gardening'),
        'transport' => 'refresh',
        'section'   => 'organic_gardening_footer_section',
        'type'      => 'icon'
    )));

    $wp_customize->add_setting('organic_gardening_scroll_top_alignment',array(
        'default' => 'right-align',
        'sanitize_callback' => 'organic_gardening_sanitize_scroll_top_alignment'
    ));
    $wp_customize->add_control('organic_gardening_scroll_top_alignment',array(
        'type' => 'select',
        'label' => __('Scroll Top Alignment','organic-gardening'),
        'section' => 'organic_gardening_footer_section',
        'choices' => array(
            'right-align' => __('Right Alignment','organic-gardening'),
            'center-align' => __('Center Alignment','organic-gardening'),
            'left-align' => __('Left Alignment','organic-gardening'),
        ),
    ) );

    /** Scroll to top button shape */
    $wp_customize->add_setting('organic_gardening_scroll_to_top_radius', array(
        'default'           => 'curved-box',
        'sanitize_callback' => 'organic_gardening_sanitize_choices',
    ));

    $wp_customize->add_control('organic_gardening_scroll_to_top_radius', array(
        'label'    => __('Scroll Top Button Shape', 'organic-gardening'),
        'section'  => 'organic_gardening_footer_section',
        'settings' => 'organic_gardening_scroll_to_top_radius',
        'type'     => 'select',
        'choices'  => array(
            'box'        => __( 'Box', 'organic-gardening' ),
            'curved-box' => __( 'Curved Box', 'organic-gardening' ),
            'circle'     => __( 'Circle', 'organic-gardening' ),
        ),
    ));

    // 404 PAGE SETTINGS
    $wp_customize->add_section(
        'organic_gardening_404_section',
        array(
            'title' => __( '404 Page Settings', 'organic-gardening' ),
            'priority' => 70,
            'panel' => 'organic_gardening_general_settings',
        )
    );
   
    $wp_customize->add_setting('404_page_image', array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw', // Sanitize as URL
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, '404_page_image', array(
        'label' => __('404 Page Image', 'organic-gardening'),
        'section' => 'organic_gardening_404_section',
        'settings' => '404_page_image',
    )));

    $wp_customize->add_setting('404_pagefirst_header', array(
        'default' => __('404', 'organic-gardening'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_pagefirst_header', array(
        'type' => 'text',
        'label' => __('Heading', 'organic-gardening'),
        'section' => 'organic_gardening_404_section',
    ));

    // Setting for 404 page header
    $wp_customize->add_setting('404_page_header', array(
        'default' => __('Sorry, that page can\'t be found!', 'organic-gardening'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_page_header', array(
        'type' => 'text',
        'label' => __('Heading', 'organic-gardening'),
        'section' => 'organic_gardening_404_section',
    ));

}
add_action( 'customize_register', 'organic_gardening_customize_register' );
endif;

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function organic_gardening_customize_preview_js() {
    // Use minified libraries if SCRIPT_DEBUG is false
    $organic_gardening_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $organic_gardening_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'organic_gardening_customizer', get_template_directory_uri() . '/js' . $organic_gardening_build . '/customizer' . $organic_gardening_suffix . '.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'organic_gardening_customize_preview_js' );