<?php 
/**
 * Template part for displaying Featured Service Section
 *
 * @package organic_gardening
 */

$organic_gardening_classes = get_theme_mod( 'organic_gardening_classes_setting',false );
$organic_gardening_service_title = get_theme_mod( 'organic_gardening_service_title' );
$organic_gardening_service_text = get_theme_mod( 'organic_gardening_service_text' );

?>
<?php if ( $organic_gardening_classes ){?>
<div class="our-classes">
    <div class="container">
        <div class="row">
            <div class="col-lg-3 col-md-4 service-detail">
                <div class="side-border">
                    <?php if ( $organic_gardening_service_title ){?>
                        <h3 class="mb-1"><?php echo esc_html( $organic_gardening_service_title );?></h3>
                    <?php } ?>  
                    <?php if ( $organic_gardening_service_text ){?>
                        <p class="title-text"><?php echo esc_html( $organic_gardening_service_text );?></p>
                    <?php } ?> 
                      <?php $organic_gardening_about_point = get_theme_mod('organic_gardening_about_points','4');
                          for ( $organic_gardening_m = 1; $organic_gardening_m <= $organic_gardening_about_point; $organic_gardening_m++ ){ ?>
                            <ul>
                                <li><?php echo esc_html(get_theme_mod('organic_gardening_about_points_text'.$organic_gardening_m,'')); ?></li>
                            </ul>
                        <?php } ?>
                    <div class="service-btn">
                      <?php if ( get_theme_mod('organic_gardening_service_button_url') ) : ?>
                        <p class="btn-green btn-2 mt-4">
                          <a target="_blank" href="<?php echo esc_url(get_theme_mod('organic_gardening_service_button_url'));?>"><?php esc_html_e('Our Service','organic-gardening'); ?><i class="far fa-arrow-alt-circle-right"></i></a>
                        </p>
                      <?php endif; ?>               
                    </div>                     
                </div>
            </div>
            <div class="col-lg-9 col-md-8 service-cat">
                <div class="row">
                    <?php 
                    $organic_gardening_catergory_name = get_theme_mod('organic_gardening_blog_args_');
                    $args = array(
                        'post_type'           => 'post',
                        'category_name'       => $organic_gardening_catergory_name,
                        'orderby'             => 'post__in',
                        'ignore_sticky_posts' => true,
                        'posts_per_page'      => 8,
                    );
                    ?>
                    <?php
                    $loop = new WP_Query($args);
                    if ( $loop->have_posts() ) :
                        $i=1;
                        while ($loop->have_posts()) : $loop->the_post(); ?>
                            <div class="col-lg-3 col-md-6 align-self-center px-0">
                                <div class="box">
                                    <div class="box-content">
                                    <?php if( get_theme_mod( 'organic_gardening_category_icon'.$i ) != '' ) { ?>
                                        <span><i class="<?php echo esc_attr(get_theme_mod('organic_gardening_category_icon'.$i)); ?>"></i></span>
                                    <?php } ?>
                                        <h4 class="title mb-2 mt-2"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                    </div>
                                </div>
                            </div>
                        <?php  $i++; endwhile;
                    endif;?>  
                </div>
            </div>          
        </div>
    </div>
</div>
<?php } ?>