<?php
/**
 * Banner Section
 * 
 * @package organic_gardening
 */
$organic_gardening_slider = get_theme_mod( 'organic_gardening_slider_setting',false );
$organic_gardening_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('organic_gardening_blog_slide_category'),
  'posts_per_page' => 3,
); ?>

<?php if ( $organic_gardening_slider ){?>
  <div class="banner">
    <div class="owl-carousel">
      <?php $organic_gardening_arr_posts = new WP_Query( $organic_gardening_args );
      if ( $organic_gardening_arr_posts->have_posts() ) :
        while ( $organic_gardening_arr_posts->have_posts() ) :
          $organic_gardening_arr_posts->the_post();
          ?>
          <div class="banner_inner_box">
            <?php
              if ( has_post_thumbnail() ) :
                the_post_thumbnail();
              else:
                ?>
                <div class="banner_inner_box">
                  <img src="<?php echo get_stylesheet_directory_uri() . '/images/slide.png'; ?>">
                </div>
                <?php
              endif;
            ?>
            <div class="banner_box">
              <h3 class="my-3"><?php the_title(); ?></h3>
                <div class="slide-btns">
                  <?php if ( get_theme_mod('organic_gardening_slider_second_button_url') ) : ?>
                    <p class="btn-green btn-2 mt-4">
                      <a target="_blank" href="<?php echo esc_url(get_theme_mod('organic_gardening_slider_second_button_url'));?>"><?php esc_html_e('Our Service','organic-gardening'); ?><i class="far fa-arrow-alt-circle-right"></i></a>
                    </p>
                  <?php endif; ?> 
                  <p class="btn-green mt-4">
                    <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('More About Us','organic-gardening'); ?></a>
                  </p>               
                </div>
            </div>
          </div>
        <?php
      endwhile;
      wp_reset_postdata();
      endif; ?>
    </div>
  </div>
<?php } ?>