<?php
/**
 * Organic Gardening functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package organic_gardening
 */

$organic_gardening_theme_data = wp_get_theme();
if( ! defined( 'ORGANIC_GARDENING_THEME_VERSION' ) ) define ( 'ORGANIC_GARDENING_THEME_VERSION', $organic_gardening_theme_data->get( 'Version' ) );
if( ! defined( 'ORGANIC_GARDENING_THEME_NAME' ) ) define( 'ORGANIC_GARDENING_THEME_NAME', $organic_gardening_theme_data->get( 'Name' ) );

if ( ! function_exists( 'organic_gardening_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function organic_gardening_setup() {

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary', 'organic-gardening' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See https://developer.wordpress.org/themes/functionality/post-formats/
	 */
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
		'gallery',
        'status',
        'audio', 
        'chat'
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'organic_gardening_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	/* Custom Logo */
    add_theme_support( 'custom-logo', array(
    	'header-text' => array( 'site-title', 'site-description' ),
    ) );

    load_theme_textdomain( 'organic-gardening' );
}
endif;
add_action( 'after_setup_theme', 'organic_gardening_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $organic_gardening_content_width
 */
function organic_gardening_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'organic_gardening_content_width', 780 );
}
add_action( 'after_setup_theme', 'organic_gardening_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function organic_gardening_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Header Sidebar', 'organic-gardening' ),
		'id'            => 'header-sidebar',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Option', 'organic-gardening' ),
		'id'            => 'right-sidebar',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Two', 'organic-gardening' ),
		'id'            => 'sidebar-2',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar Three', 'organic-gardening' ),
		'id'            => 'sidebar-3',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Footer One', 'organic-gardening' ),
		'id'            => 'footer-one',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
    
    register_sidebar( array(
		'name'          => esc_html__( 'Footer Two', 'organic-gardening' ),
		'id'            => 'footer-two',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
    
    register_sidebar( array(
		'name'          => esc_html__( 'Footer Three', 'organic-gardening' ),
		'id'            => 'footer-three',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Four', 'organic-gardening' ),
		'id'            => 'footer-four',
		'description'   => '',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

}
add_action( 'widgets_init', 'organic_gardening_widgets_init' );

if( ! function_exists( 'organic_gardening_scripts' ) ) :

/**
 * Enqueue scripts and styles.
 */
function organic_gardening_scripts() {

	// Use minified libraries if SCRIPT_DEBUG is false
    $organic_gardening_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $organic_gardening_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    wp_enqueue_style( 'bootstrap-style', get_template_directory_uri().'/css/build/bootstrap.css' );
    wp_enqueue_style( 'owl.carousel', get_template_directory_uri() . '/css/build/owl.carousel.css' );

    wp_enqueue_style( 'fontawesome-all', esc_url(get_template_directory_uri()).'/css/all.min.css');

	wp_enqueue_style( 'organic-gardening-style', get_stylesheet_uri(), array(), ORGANIC_GARDENING_THEME_VERSION );

	require get_parent_theme_file_path( '/inc/css_custom.php' );
	wp_add_inline_style( 'organic-gardening-style',$organic_gardening_custom_css );

	if( organic_gardening_woocommerce_activated() ) 
    wp_enqueue_style( 'organic-gardening-woocommerce-style', get_template_directory_uri(). '/css' . $organic_gardening_build . '/woocommerce' . $organic_gardening_suffix . '.css', array('organic-gardening-style'), ORGANIC_GARDENING_THEME_VERSION );
	
  	wp_enqueue_script( 'organic-gardening-all', get_template_directory_uri() . '/js' . $organic_gardening_build . '/all' . $organic_gardening_suffix . '.js', array( 'jquery' ), '6.1.1', true );
  	wp_enqueue_script( 'organic-gardening-v4-shims', get_template_directory_uri() . '/js' . $organic_gardening_build . '/v4-shims' . $organic_gardening_suffix . '.js', array( 'jquery' ), '6.1.1', true );
  	wp_enqueue_script( 'organic-gardening-modal-accessibility', get_template_directory_uri() . '/js' . $organic_gardening_build . '/modal-accessibility' . $organic_gardening_suffix . '.js', array( 'jquery' ), ORGANIC_GARDENING_THEME_VERSION, true );
	wp_enqueue_script( 'owl.carousel', get_template_directory_uri() . '/js/build/owl.carousel.js', array('jquery'), '2.6.0', true );
	wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/js/build/bootstrap.js', array('jquery'), '2.6.0', true );
	wp_enqueue_script( 'organic-gardening-js', get_template_directory_uri() . '/js/build/custom.js', array('jquery'), ORGANIC_GARDENING_THEME_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
endif;
add_action( 'wp_enqueue_scripts', 'organic_gardening_scripts' );

if( ! function_exists( 'organic_gardening_admin_scripts' ) ) :
/**
 * Admin scripts
*/
function organic_gardening_admin_scripts() {
	wp_enqueue_style( 'organic-gardening-admin-style',get_template_directory_uri().'/inc/css/admin.css', ORGANIC_GARDENING_THEME_VERSION, 'screen' );
}
endif;
add_action( 'admin_enqueue_scripts', 'organic_gardening_admin_scripts' );

function organic_gardening_customize_enque_js(){
	wp_enqueue_script( 'customizer', get_template_directory_uri() . '/inc/js/customizer.js', array('jquery'), '2.6.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'organic_gardening_customize_enque_js', 0 );


if( ! function_exists( 'organic_gardening_block_editor_styles' ) ) :
/**
 * Enqueue editor styles for Gutenberg
 */
function organic_gardening_block_editor_styles() {
	// Use minified libraries if SCRIPT_DEBUG is false
	$organic_gardening_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
	$organic_gardening_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	
	// Block styles.
	wp_enqueue_style( 'organic-gardening-block-editor-style', get_template_directory_uri() . '/css' . $organic_gardening_build . '/editor-block' . $organic_gardening_suffix . '.css' );
}
endif;
add_action( 'enqueue_block_editor_assets', 'organic_gardening_block_editor_styles' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';


function organic_gardening_template_setup() {

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extra.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Social Links Widget
 */
require get_template_directory() . '/inc/widget-social-links.php';

/**
 * Info Theme
 */
require get_template_directory() . '/inc/info.php';

/**
 * Info Theme
 */
require get_template_directory() . '/inc/sanitization.php';

/**
 * Getting Started
*/
require get_template_directory() . '/inc/getting-started/getting-started.php';

/**
 * setup wizard
 */
require get_parent_theme_file_path( '/theme-wizard/config.php' );

/**
 * Load plugin for right and no sidebar
 */
if( organic_gardening_woocommerce_activated() ) {
	require get_template_directory() . '/inc/woocommerce-functions.php';
}

if ( ! defined( 'ORGANIC_GARDENING_URL' ) ) {
    define( 'ORGANIC_GARDENING_URL', esc_url( 'https://www.themeignite.com/products/organic-gardening-wordpress-theme', 'organic-gardening') );
}
if ( ! defined( 'ORGANIC_GARDENING_FREE_DOC_URL' ) ) {
    define( 'ORGANIC_GARDENING_FREE_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/organic-gardening-free/', 'organic-gardening') );
}
if ( ! defined( 'ORGANIC_GARDENING_PRO_DOC_URL' ) ) {
    define( 'ORGANIC_GARDENING_PRO_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/organic-gardening-pro/', 'organic-gardening') );
}
if ( ! defined( 'ORGANIC_GARDENING_DEMO_URL' ) ) {
    define( 'ORGANIC_GARDENING_DEMO_URL', esc_url( 'https://demo.themeignite.com/organic-gardening/', 'organic-gardening') );
}
if ( ! defined( 'ORGANIC_GARDENING_REVIEW_URL' ) ) {
    define( 'ORGANIC_GARDENING_REVIEW_URL', esc_url( 'https://wordpress.org/support/theme/organic-gardening/reviews/#new-post', 'organic-gardening') );
}
if ( ! defined( 'ORGANIC_GARDENING_SUPPORT_URL' ) ) {
    define( 'ORGANIC_GARDENING_SUPPORT_URL', esc_url( 'https://wordpress.org/support/theme/organic-gardening/', 'organic-gardening') );
}
if ( ! defined( 'ORGANIC_GARDENING_BUNDLE_URL' ) ) {
    define( 'ORGANIC_GARDENING_BUNDLE_URL', esc_url( 'https://www.themeignite.com/products/wp-theme-bundle', 'organic-gardening') );
}

}
add_action('after_setup_theme', 'organic_gardening_template_setup');

/**
 * Remove header text setting and control from the Customizer.
 */
function organic_gardening_remove_customizer_setting($wp_customize) {
    // Replace 'your_setting_id' with the actual ID or name of the setting you want to remove
    $wp_customize->remove_control('display_header_text');
    $wp_customize->remove_setting('display_header_text');
}
add_action('customize_register', 'organic_gardening_remove_customizer_setting');

function organic_gardening_custom_blog_banner_title() {
    if (is_404()) {
        echo '<h1 class="entry-title">'. esc_html__( 'Comments are closed.', 'organic-gardening' ).'</h1>';
    } elseif (is_search()) {
        echo '<h1 class="entry-title">'. esc_html__( 'Search Result For.', 'organic-gardening' ).' ' . get_search_query() . '</h1>';
    } elseif (is_home() && !is_front_page()) {
        echo '<h1 class="entry-title">'. esc_html__( 'Blogs', 'organic-gardening' ).'</h1>';
    } elseif (function_exists('is_shop') && is_shop()) {
        echo '<h1 class="entry-title">'. esc_html__( 'Shop', 'organic-gardening' ).'</h1>';
    } elseif (is_page_template('template-homepage.php')) {
    } elseif (is_page()) {
        the_title('<h1 class="entry-title">', '</h1>');
    } elseif (is_single()) {
        the_title('<h1 class="entry-title">', '</h1>');
    } elseif (is_archive()) {
        the_archive_title('<h1 class="entry-title">', '</h1>');
    } else {
        the_archive_title('<h1 class="entry-title">', '</h1>');
    }
}

function organic_gardening_enqueue_google_fontss() {
    $organic_gardening_heading_font_family = get_theme_mod('organic_gardening_heading_font_family', '');
    $organic_gardening_body_font_family = get_theme_mod('organic_gardening_body_font_family', '');

    // Google Fonts URL builder
    $google_fonts = array(
        'Arial'          => '',
        'Verdana'        => '',
        'Helvetica'      => '',
        'Times New Roman'=> '',
        'Georgia'        => '',
        'Courier New'    => '',
        'Trebuchet MS'   => '',
        'Tahoma'         => '',
        'Palatino'       => '',
        'Garamond'       => '',
        'Impact'         => '',
        'Comic Sans MS'  => '',
        'Lucida Sans'    => '',
        'Arial Black'    => '',
        'Gill Sans'      => '',
        'Segoe UI'       => '',
        'Open Sans'      => 'Open+Sans:wght@400;700',
        'Roboto'         => 'Roboto:wght@400;700',
        'Lato'           => 'Lato:wght@400;700',
        'Montserrat'     => 'Montserrat:wght@400;700',
        'Libre Baskerville' => 'Libre+Baskerville:wght@400;700'
    );

    $organic_gardening_google_fonts_url = '';

    if (!empty($google_fonts[$organic_gardening_heading_font_family]) || !empty($google_fonts[$organic_gardening_body_font_family])) {
        $fonts = array();

        if (!empty($google_fonts[$organic_gardening_heading_font_family])) {
            $fonts[] = $google_fonts[$organic_gardening_heading_font_family];
        }

        if (!empty($google_fonts[$organic_gardening_body_font_family])) {
            $fonts[] = $google_fonts[$organic_gardening_body_font_family];
        }

        // Build Google Fonts URL
        $organic_gardening_google_fonts_url = add_query_arg(
            'family',
            implode('|', $fonts),
            'https://fonts.googleapis.com/css2'
        );
    }

    if ($organic_gardening_google_fonts_url) {
        wp_enqueue_style('organic-gardening-google-fonts', $organic_gardening_google_fonts_url, false);
    }
}
add_action('wp_enqueue_scripts', 'organic_gardening_enqueue_google_fontss');


/*-----------------------Typography Function---------------------------------------*/

function organic_gardening_apply_typography() {
    $organic_gardening_heading_font_family = get_theme_mod('organic_gardening_heading_font_family');
    $organic_gardening_body_font_family = get_theme_mod('organic_gardening_body_font_family');

    $organic_gardening_custom_css = '';

    if ($organic_gardening_body_font_family) {
        $organic_gardening_custom_css .= "body, a, a:active, a:hover { font-family: " . esc_html($organic_gardening_body_font_family) . " !important; }";
    }

    if ($organic_gardening_heading_font_family) {
        $organic_gardening_custom_css .= "h1, h2, h3, h4, h5, h6 { font-family: " . esc_html($organic_gardening_heading_font_family) . " !important; }";
    }

    if (!empty($organic_gardening_custom_css)) {
        wp_add_inline_style('organic-gardening-style', $organic_gardening_custom_css);
    }
}
add_action('wp_enqueue_scripts', 'organic_gardening_apply_typography');


/*-----------------------Menu Typography---------------------------------------*/

function organic_gardening_menu_customizer_css() {
    $organic_gardening_menu_font_weight = get_theme_mod('organic_gardening_menu_font_weight', 'bold');
    $organic_gardening_menu_text_transform = get_theme_mod('organic_gardening_menu_text_transform', 'capitalize');

    $organic_gardening_custom_css = "
        .main-navigation ul li a {
            font-weight: " . esc_html($organic_gardening_menu_font_weight) . ";
            text-transform: " . esc_html($organic_gardening_menu_text_transform) . ";
        }
    ";

    wp_add_inline_style('organic-gardening-style', $organic_gardening_custom_css);
}
add_action('wp_enqueue_scripts', 'organic_gardening_menu_customizer_css');

/*-----------------------Menu Typography---------------------------------------*/

/**
 * Display the admin notice unless dismissed.
 */
function organic_gardening_dashboard_notice() {
    // Check if the notice is dismissed
    $dismissed = get_user_meta(get_current_user_id(), 'organic_gardening_dismissable_notice', true);

    // Display the notice only if not dismissed
    if (!$dismissed) {
        ?>
        <div class="updated notice notice-success is-dismissible notice-get-started-class" data-notice="get-start">
        	<div class="notice-details">
        		<div class="notice-content">
					<h2><?php /* translators: %s: Theme name */printf( esc_html__( 'Thanks you for installing %s.', 'organic-gardening' ), '<strong>Organic Gardening</strong>' );?></h2>
		            <p><?php echo esc_html('Your journey to a powerful and stylish website begins here. Let’s get everything set up in just a few clicks!', 'organic-gardening'); ?></p>
		            <div class="notice-btns">
			           	<a style="margin-bottom: 15px; padding: 8px 15px;" class="button button-primary getstart"
			               href="<?php echo esc_url(admin_url('themes.php?page=organic-gardening')); ?>"><?php esc_html_e('Getting Started', 'organic-gardening') ?></a>
			        	<a style="margin-left: 30px; margin-bottom: 15px; padding: 8px 15px;" class="button button-primary import"
			               href="<?php echo esc_url(admin_url('themes.php?page=organicgardening-wizard')); ?>"><?php esc_html_e('Demo Importer', 'organic-gardening') ?></a>
			           <a style="margin-left: 30px; padding: 8px 15px;" class="button button-primary premium"
			           target="_blank" href="<?php echo esc_url('https://www.themeignite.com/products/organic-gardening-wordpress-theme'); ?>"><?php esc_html_e('Go To Premium', 'organic-gardening') ?></a>
		            </div>
        		</div>
        		<div class="notice-img">
        			<img src="<?php echo esc_url( get_template_directory_uri() . '/images/notice.png' ); ?>">
        		</div>
        		
        	</div>
        </div>
        <?php
    }
}

// Hook to display the notice
add_action('admin_notices', 'organic_gardening_dashboard_notice');

/**
 * AJAX handler to dismiss the notice.
 */
function organic_gardening_dismissable_notice() {
    // Set user meta to indicate the notice is dismissed
    update_user_meta(get_current_user_id(), 'organic_gardening_dismissable_notice', true);
    die();
}

// Hook for the AJAX action
add_action('wp_ajax_organic_gardening_dismissable_notice', 'organic_gardening_dismissable_notice');

/**
 * Clear dismissed notice state when switching themes.
 */
function organic_gardening_switch_theme() {
    // Clear the dismissed notice state when switching themes
    delete_user_meta(get_current_user_id(), 'organic_gardening_dismissable_notice');
}

// Hook for switching themes
add_action('after_switch_theme', 'organic_gardening_switch_theme');