<?php

/**
 * Loop Add to Cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/add-to-cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 * Modified
 */
if (!defined('ABSPATH')) {
    exit;
}

global $product;
$args['class'] = str_replace('button', '', $args['class']);

if ($product->is_type('simple')) {

    echo esc_html(apply_filters('woocommerce_loop_add_to_cart_link', // phpcs:ignore Standard.Category.SniffName.ErrorCode.
                    sprintf('<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
                            esc_url($product->add_to_cart_url()),
                            esc_attr(isset($args['quantity']) ? $args['quantity'] : 1 ),
                            esc_attr(isset($args['class']) ? $args['class'] : 'btn btn-add-to-cart' ),
                            isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
                            '<i class="fas fa-cart-plus"></i>'
                    ),
                    $product, $args));
} elseif ($product->is_type('variable')) {

    echo esc_html(apply_filters('woocommerce_loop_add_to_cart_link', // phpcs:ignore Standard.Category.SniffName.ErrorCode.
                    sprintf('<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
                            esc_url($product->add_to_cart_url()),
                            esc_attr(isset($args['quantity']) ? $args['quantity'] : 1 ),
                            esc_attr(isset($args['class']) ? $args['class'] : 'btn btn-add-to-cart' ),
                            isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
                            esc_html($product->add_to_cart_text())
                    ),
                    $product, $args));
} else {
    echo esc_html(apply_filters('woocommerce_loop_add_to_cart_link', // phpcs:ignore Standard.Category.SniffName.ErrorCode.
                    sprintf('<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
                            esc_url($product->add_to_cart_url()),
                            esc_attr(isset($args['quantity']) ? $args['quantity'] : 1 ),
                            esc_attr(isset($args['class']) ? $args['class'] : 'btn btn-add-to-cart' ),
                            isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
                            esc_html($product->add_to_cart_text())
                    ),
                    $product, $args));
}