<?php

/**
 * Meta Box API Generator
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package WordPress
 * @subpackage Orbital Go
 * @since 1.0
 */
/*
 *
 * text, checkbox, color, date, datetime, datetime-local
 * email, media, month, number, password, radio, range,
 * select, tel, textarea, time, url, week
 *
 */

/*
 * Fields to Meta Box
 */

if (!function_exists('orbital_get_meta_fields')) :

    function orbital_get_meta_fields() {

        $fields = array(
            array(
                'id' => 'subtitle',
                'label' => __('Subtitle', 'orbital-go'),
                'type' => 'textarea',
                'default' => '',
            ),
            array(
                'id' => 'sidebar',
                'label' => __('Sidebar', 'orbital-go'),
                'type' => 'checkbox',
                'default' => '1',
            ),
            array(
                'id' => 'thumbnail',
                'label' => __('Thumbnail', 'orbital-go'),
                'type' => 'checkbox',
                'default' => '1',
            ),
            array(
                'id' => 'pilar',
                'label' => __('Pilar Page', 'orbital-go'),
                'type' => 'checkbox',
            ),
            array(
                'id' => 'related',
                'label' => __('Related Posts', 'orbital-go'),
                'type' => 'checkbox',
                'default' => '1',
            ),
            array(
                'id' => 'custom-sidebar',
                'label' => __('Custom Sidebar', 'orbital-go'),
                'type' => 'select',
                'options' => orbital_dynamic_sidebar(),
            ),
        );
        return $fields;
    }

endif;

/*
 * Select Type of template to Meta Box
 */

if (!function_exists('orbital_get_meta_screens')) :

    function orbital_get_meta_screens() {
        $screens = array(
            'post',
            'page',
        );
        return $screens;
    }

endif;

/*
 * Launch Meta Box
 */

if (!function_exists('orbital_add_meta_boxes')) :

    function orbital_add_meta_boxes() {

        $screens = orbital_get_meta_screens();
        foreach ($screens as $screen) {
            add_meta_box(
                    'option-page',
                    __('Option Page', 'orbital-go'),
                    'orbital_add_meta_box_callback',
                    $screen,
                    'advanced',
                    'high'
            );
        }
    }

endif;


/*
 * Meta Box Field Callback
 */

if (!function_exists('orbital_add_meta_box_callback')) :

    function orbital_add_meta_box_callback($post) {
        wp_nonce_field('option_page_data', 'option_page_nonce');
        orbital_generate_fields($post);
    }

endif;


/*
 * Javascript for Meta Box WP Editor
 */

if (!function_exists('orbital_admin_footer')) :

    function orbital_admin_footer() {
        ?>
        <script>
            jQuery(document).ready(function ($) {
                if (typeof wp.media !== 'undefined') {
                    var _custom_media = true,
                            _orig_send_attachment = wp.media.editor.send.attachment;
                    $('.rational-metabox-media').click(function (e) {
                        var send_attachment_bkp = wp.media.editor.send.attachment;
                        var button = $(this);
                        var id = button.attr('id').replace('_button', '');
                        _custom_media = true;
                        wp.media.editor.send.attachment = function (props, attachment) {
                            if (_custom_media) {
                                $("#" + id).val(attachment.url);
                            } else {
                                return _orig_send_attachment.apply(this, [props, attachment]);
                            }
                            ;
                        }
                        wp.media.editor.open(button);
                        return false;
                    });
                    $('.add_media').on('click', function () {
                        _custom_media = false;
                    });
                }
            });
        </script>
        <?php

    }

endif;

/*
 * Generate Fields for Meta Box
 */

if (!function_exists('orbital_generate_fields')) :

    function orbital_generate_fields($post) {

        $output = '';
        $fields = orbital_get_meta_fields();
        foreach ($fields as $field) {
            $label = '<label for="' . $field['id'] . '">' . $field['label'] . '</label>';
            $db_value = get_post_meta($post->ID, 'option_page_' . $field['id'], true);

            if ($db_value === '') {
                if (isset($field['default'])) {
                    $db_value = $field['default'];
                }
            }

            switch ($field['type']) {
                case 'checkbox':
                    $input = sprintf(
                            '<input %s id="%s" name="%s" type="checkbox" value="1">',
                            $db_value === '1' ? 'checked' : '',
                            $field['id'],
                            $field['id']
                    );
                    break;
                case 'media':
                    $input = sprintf(
                            '<input class="regular-text" id="%s" name="%s" type="text" value="%s"> <input class="button rational-metabox-media" id="%s_button" name="%s_button" type="button" value="Upload" />',
                            $field['id'],
                            $field['id'],
                            $db_value,
                            $field['id'],
                            $field['id']
                    );
                    break;
                case 'radio':
                    $input = '<fieldset>';
                    $input .= '<legend class="screen-reader-text">' . $field['label'] . '</legend>';
                    $i = 0;
                    foreach ($field['options'] as $key => $value) {
                        $field_value = !is_numeric($key) ? $key : $value;
                        $input .= sprintf(
                                '<label><input %s id="%s" name="%s" type="radio" value="%s"> %s</label>%s',
                                $db_value === $field_value ? 'checked' : '',
                                $field['id'],
                                $field['id'],
                                $field_value,
                                $value,
                                $i < count($field['options']) - 1 ? '<br>' : ''
                        );
                        $i++;
                    }
                    $input .= '</fieldset>';
                    break;
                case 'select':
                    $input = sprintf(
                            '<select id="%s" name="%s">',
                            $field['id'],
                            $field['id']
                    );
                    $input .= '<option value="">---</option>';
                    foreach ($field['options'] as $key => $value) {
                        $field_value = !is_numeric($key) ? $key : $value;
                        $input .= sprintf(
                                '<option %s value="%s">%s</option>',
                                $db_value == $key ? 'selected' : '',
                                $key,
                                $value
                        );
                    }
                    $input .= '</select>';
                    break;
                case 'textarea':
                    $input = sprintf(
                            '<textarea class="large-text" id="%s" name="%s" rows="3">%s</textarea>',
                            $field['id'],
                            $field['id'],
                            $db_value
                    );
                    break;
                default:
                    $input = sprintf(
                            '<input %s id="%s" name="%s" type="%s" value="%s">',
                            $field['type'] !== 'color' ? 'class="regular-text"' : '',
                            $field['id'],
                            $field['id'],
                            $field['type'],
                            $db_value
                    );
            }
            $output .= orbital_row_format($label, $input);
        }


        global $allowedposttags;
        $posttags = $allowedposttags;
        $allowed_atts = array(
            'align' => array(),
            'class' => array(),
            'type' => array(),
            'id' => array(),
            'dir' => array(),
            'lang' => array(),
            'style' => array(),
            'xml:lang' => array(),
            'src' => array(),
            'alt' => array(),
            'href' => array(),
            'rel' => array(),
            'rev' => array(),
            'target' => array(),
            'novalidate' => array(),
            'type' => array(),
            'value' => array(),
            'name' => array(),
            'tabindex' => array(),
            'action' => array(),
            'method' => array(),
            'for' => array(),
            'width' => array(),
            'height' => array(),
            'data' => array(),
            'title' => array(),
            'checked' => array(),
            'readonly' => array(),
            'option' => array(),
            'value' => array(),
            'selected' => array(),
        );
        $posttags['form'] = $allowed_atts;
        $posttags['label'] = $allowed_atts;
        $posttags['input'] = $allowed_atts;
        $posttags['textarea'] = $allowed_atts;
        $posttags['option'] = $allowed_atts;
        $posttags['select'] = $allowed_atts;
        $posttags['textarea'] = $allowed_atts;
        $posttags['iframe'] = $allowed_atts;
        $posttags['script'] = $allowed_atts;
        $posttags['style'] = $allowed_atts;
        $posttags['strong'] = $allowed_atts;
        $posttags['small'] = $allowed_atts;
        $posttags['table'] = $allowed_atts;
        $posttags['span'] = $allowed_atts;
        $posttags['abbr'] = $allowed_atts;
        $posttags['code'] = $allowed_atts;
        $posttags['pre'] = $allowed_atts;
        $posttags['div'] = $allowed_atts;
        $posttags['img'] = $allowed_atts;
        $posttags['h1'] = $allowed_atts;
        $posttags['h2'] = $allowed_atts;
        $posttags['h3'] = $allowed_atts;
        $posttags['h4'] = $allowed_atts;
        $posttags['h5'] = $allowed_atts;
        $posttags['h6'] = $allowed_atts;
        $posttags['ol'] = $allowed_atts;
        $posttags['ul'] = $allowed_atts;
        $posttags['li'] = $allowed_atts;
        $posttags['em'] = $allowed_atts;
        $posttags['hr'] = $allowed_atts;
        $posttags['br'] = $allowed_atts;
        $posttags['tr'] = $allowed_atts;
        $posttags['td'] = $allowed_atts;
        $posttags['p'] = $allowed_atts;
        $posttags['a'] = $allowed_atts;
        $posttags['b'] = $allowed_atts;
        $posttags['i'] = $allowed_atts;


        echo '<table class="form-table"><tbody>' . wp_kses($output, $posttags) . '</tbody></table>';
    }

endif;


/*
 * Format to Meta Box Fields
 */

if (!function_exists('orbital_row_format')) :

    function orbital_row_format($label, $input) {
        return sprintf('<tr><th scope="row">%s</th><td>%s</td></tr>', $label, $input);
    }

endif;


/*
 * Save Meta Box data
 */

if (!function_exists('orbital_save_post')) :

    function orbital_save_post($post_id) {

        if (!isset($_POST['option_page_nonce'])) {
            return $post_id;
        }
        $nonce = sanitize_text_field(wp_unslash($_POST['option_page_nonce']));
        if (!wp_verify_nonce($nonce, 'option_page_data')) {
            return $post_id;
        }
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return $post_id;
        }
        $fields = orbital_get_meta_fields();
        foreach ($fields as $field) {
            if (isset($_POST[$field['id']])) {
                switch ($field['type']) {
                    case 'email':
                        $_POST[$field['id']] = sanitize_email(wp_unslash($_POST[$field['id']]));
                        break;
                    case 'text':
                        $_POST[$field['id']] = sanitize_text_field(wp_unslash($_POST[$field['id']]));
                        break;
                }
                update_post_meta($post_id, 'option_page_' . $field['id'], sanitize_text_field(wp_unslash($_POST[$field['id']])));
            } else if ($field['type'] === 'checkbox') {
                update_post_meta($post_id, 'option_page_' . $field['id'], '0');
            }
        }
    }

endif;

/*
 * Get Meta Post Options
 */

if (!function_exists('orbital_get_option_page')) :

    function orbital_get_option_page($option, $default = true) {
        if (get_post_meta(get_the_ID(), 'option_page_' . $option, false)) {
            return get_post_meta(get_the_ID(), 'option_page_' . $option, true);
        }
        return $default;
    }

endif;

if (!function_exists('orbital_dynamic_sidebar')) :

    function orbital_dynamic_sidebar() {

        global $wp_registered_sidebars;

        $widget_areas = array();


        foreach ($wp_registered_sidebars as $sidebar => $value) {
            $widget_areas[$sidebar] = $value['name'];
        }

        ksort($widget_areas);
        return $widget_areas;
    }





endif;
