<?php
/**
 * Extra functions
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package WordPress
 * @subpackage Orbital Go
 * @since 1.0
 */
/*
 * Return and modify excerpt Lenght
 */

if (!function_exists('orbital_excerpt_length')) :

    function orbital_excerpt_length($length) {

        if (orbital_customize_option('orbital_loop_excerpt_lenght')) {
            return orbital_customize_option('orbital_loop_excerpt_lenght');
        } else {
            return 10;
        }
    }

endif;

/*
 * Print Excerpt More
 */

if (!function_exists('orbital_excerpt_more')) :

    function orbital_excerpt_more($more) {
        return ' <a class="entry-read-more" href="' . get_the_permalink() . '">' . orbital_customize_option('orbital_loop_read_more') . '</a>';
    }

endif;



/*
 * Future featured
 */

if (!function_exists('orbital_next_page')) :

    function orbital_next_page($buttons, $id) {

        if ('content' != $id) {
            return $buttons;
        }
        array_splice($buttons, 13, 0, 'wp_page');
        return $buttons;
    }

endif;


/*
 * Future featured
 */

if (!function_exists('orbital_page_layout')) :

    function orbital_page_layout($default = "") {

        if (orbital_get_option_page('layout')) {
            return orbital_get_option_page('layout');
        } else {
            return $default;
        }
    }

endif;

/*
 * Add Mime Types
 */

if (!function_exists('orbital_mime_types')) :

    function orbital_mime_types($mimes) {
        $mimes['svg'] = 'image/svg+xml';
        return $mimes;
    }

endif;


/*
 * Check if sidebar is activated and add class nosidebar if is not
 */

if (!function_exists('orbital_check_sidebar_class')) :

    function orbital_check_sidebar_class($classes) {
        if (orbital_check_woocommerce()) {
            if (!is_active_sidebar('shop') && is_woocommerce()) {
                $classes[] = 'no-sidebar';
            } elseif (is_woocommerce()) {
                return $classes;
            }
        }
        if (
                !is_active_sidebar('pages') && is_page() || !is_active_sidebar('posts') && is_single() || !is_active_sidebar('archives') && is_archive() || !is_active_sidebar('page-home') && is_home() || !is_active_sidebar('pilar') && is_page_template('templates/pilar.php') || !orbital_get_option_page('sidebar')
        ) {
            $classes[] = 'no-sidebar';
        }
        return $classes;
    }

endif;


/*
 * Add Custom Excerpt to Pages
 */

if (!function_exists('orbital_excerpts_to_pages')) :

    function orbital_excerpts_to_pages() {
        add_post_type_support('page', 'excerpt');
    }

endif;


/*
 * Categorized Blog
 */

if (!function_exists('orbital_categorized_blog')) :

    function orbital_categorized_blog() {
        if (false === ( $all_the_cool_cats = get_transient('orbital_categories') )) {
            $all_the_cool_cats = get_categories(array(
                'fields' => 'ids',
                'hide_empty' => 1,
                'number' => 2,
            ));
            $all_the_cool_cats = count($all_the_cool_cats);
            set_transient('orbital_categories', $all_the_cool_cats);
        }
        if ($all_the_cool_cats > 1) {
            return true;
        } else {
            return false;
        }
    }

endif;


/*
 * Category Trasient Flusher
 */

if (!function_exists('orbital_category_transient_flusher')) :

    function orbital_category_transient_flusher() {
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }
        delete_transient('orbital_categories');
    }

endif;

/*
 * Add custom Buttons to WP Editor WYSIWYG
 */

if (!function_exists('orbital_add_custom_buttons')) :

    function orbital_add_custom_buttons() {

        global $typenow;

        if (!current_user_can('edit_posts') && !current_user_can('edit_pages')) {
            return;
        }

        if (!in_array($typenow, array('page', 'post'))) {
            return;
        }

        if (get_user_option('rich_editing') == 'true') {
            add_filter("mce_external_plugins", "orbital_add_tinymce_plugin");
            add_filter('mce_buttons', 'orbital_register_custom_buttons');
        }
    }

endif;


/*
 * Register WP Editor Buttons
 */

if (!function_exists('orbital_add_tinymce_plugin')) :

    function orbital_add_tinymce_plugin($plugin_array) {
        $plugin_array['orbital_tc_button'] = get_template_directory_uri() . '/assets/js/admin.js';
        return $plugin_array;
    }

endif;


if (!function_exists('orbital_register_custom_buttons')) :

    function orbital_register_custom_buttons($buttons) {
        array_push($buttons, "orbital_tc_button");
        return $buttons;
    }

endif;


/*
 * Remove Hentry Class
 */

if (!function_exists('orbital_remove_hentry')) :

    function orbital_remove_hentry($classes) {
        if (is_singular()) {
            $classes = array_diff($classes, array('hentry'));
        }
        return $classes;
    }

endif;


/*
 * Add WP Editor Extra to Categories
 */

if (!function_exists('orbital_cat_description')) :

    function orbital_cat_description($tag) {
        $cat_extra_description = get_term_meta($tag->term_id, 'cat_extra_description', true);
        ?>
        <table class="form-table">
            <tr class="form-field">
                <th scope="row" valign="top">
                    <label for="description"><?php esc_html_e('Top Description', 'orbital-go'); ?></label>
                </th>
                <td><?php
                    $settings = array(
                        'wpautop' => true,
                        'media_buttons' => true,
                        'quicktags' => true,
                        'textarea_rows' => '10',
                        'textarea_name' => 'cat_extra_description',
                        'drag_drop_upload' => true
                    );
                    wp_editor(wp_kses_post($cat_extra_description, ENT_QUOTES, 'UTF-8'), 'cat_extra_description', $settings);
                    ?>
                    <br />
                    <span class="description"><?php esc_html_e('The description is not prominent by default; however, some themes may show it.', 'orbital-go'); ?></span>
                </td>
            </tr>
        </table><?php
    }

endif;


if (!function_exists('orbital_save_extra_category_fields')) :

    function orbital_save_extra_category_fields($term_id) {
        if (isset($_POST['cat_extra_description']) && isset($_POST['tag_ID'])) {
            update_term_meta(esc_url_raw(wp_unslash($_POST['tag_ID'])), 'cat_extra_description', esc_url_raw(wp_unslash($_POST['cat_extra_description'])));
        }
    }

endif;


/*
 * Modify default textarea comments
 */

if (!function_exists('orbital_comment_textarea')) :

    function orbital_comment_textarea($arg) {
        $arg['comment_field'] = '<textarea id="comment" name="comment" cols="45" rows="1" required></textarea>';
        return $arg;
    }

endif;



add_filter('wp_nav_menu_items', 'orbital_search_navbar', 99, 2);

function orbital_search_navbar($items, $args) {
    if (!orbital_customize_option('orbital_layout_search_navbar')) {
        return $items;
    }

    ob_start();
    ?>
    <script>
        function orbital_expand_navbar() {

            var element = document.getElementById("search-navbar");

            if (element.classList.contains('expand-searchform')) {
                element.classList.remove("expand-searchform");
                return;
            } else {
                element.classList.add("expand-searchform");
                document.getElementById("search-input").focus();
            }

        }
    </script>
    <a href="#" onclick="orbital_expand_navbar()" class="text-center"><i class="fa fa-search fa-sm"></i></a>
    <?php
    $searchform = ob_get_contents();
    ob_end_clean();

    $items .= '<li class="menu-item">' . $searchform . '</li>';

    return $items;
}

function orbital_get_domain() {
    $sURL = home_url();
    $asParts = parse_url($sURL);

    if (!$asParts) {
        wp_die('ERROR: Path corrupt for parsing.');
    }
    $sScheme = $asParts['scheme'];
    $sHost = $asParts['host'];
    $sReturn = $sScheme . '://' . $sHost;

    return $sReturn;
}

if (!function_exists('orbital_post_meta_request_params')) :

    function orbital_post_meta_request_params($args, $request) {
        $args += array(
            'meta_key' => $request['meta_key'],
            'meta_value' => $request['meta_value'],
            'meta_query' => $request['meta_query'],
        );
        return $args;
    }

    add_filter('rest_post_query', 'orbital_post_meta_request_params', 99, 2);
    add_filter('rest_page_query', 'orbital_post_meta_request_params', 99, 2);
endif;
require get_template_directory() . '/vendor/admin-notices/persist-admin-notices-dismissal.php';

function orbital_free_admin_notice() {
    global $pagenow;
        if (  PAnD::is_admin_notice_active( 'orbital-pro-banner' ) ) {
            $orbital_protocol = "https://";
            $orbital_external_link = $orbital_protocol . "orbitalthemes.net/";
            ?>
            <style>
                .orbital-admin-notice {
                    padding: 20px 10px;
                    display: -webkit-flex;
                    display: -moz-flex;
                    display: -ms-flex;
                    display: -o-flex;
                    display: flex;
                    -ms-align-items: center;
                    align-items: center;
                }
                .orbital-notice-image img {
                    width: 100%;
                    max-width: 200px;
                    display: inline-block;
                    vertical-align: top;

                }
                .orbital-notice-content {
                    width: 70%;
                    display: block;
                    vertical-align: top;
                    padding: 0 40px;
                }
                .orbital-notice-content h2 {
                    margin: 0 0 10px;
                    font-weight: 400;
                    line-height: 1.3;
                }
                .button-notice {
                    font-size: 14px;
                    min-height: 46px !important;
                    line-height: 3.14285714;
                    padding: 0 36px;
                    margin-top:25px !important;

                }
                .orbital-dissmiss:before {
                    background: 0 0;
                    color: #787c82;
                    content: "\f153";
                    display: block;
                    font: normal 16px/20px dashicons;
                    speak: never;
                    height: 20px;
                    text-align: center;
                    width: 20px;
                }
                .orbital-dissmiss {
                    float:right;
                    border: none;
                    margin: 0;
                    padding: 9px;
                    background: 0 0;
                    color: #787c82;
                    cursor: pointer;
                }
            </style>
            <div data-dismissible="orbital-pro-banner" class="updated notice is-dismissible">
                <div class="orbital-admin-notice clearfix">
                                
                    <div class="orbital-notice-image">
                        <img src="<?php echo esc_url(get_stylesheet_directory_uri()); ?>/assets/images/admin-notice.png" class="screenshot" alt="Theme image" />
                    </div>
                    <div class="orbital-notice-content">
                        <h2 >
                            <?php echo esc_html__('Thank you for installing Orbital Go!', 'orbital-go') ?>
                        </h2>
                        

                        <p class="plugin-install-notice">
                            <?php /* translators: %1$s: First Link Open Tag, %2$s: First Link Close Tag, %3$s: Second Link Open Tag, %4$s: Second Link Close Tag */ ?>
                            <?php printf( esc_html__( 'In our %1$sFAQ%2$s you will find all the steps to learn how to use Orbital, as well as information about the advantages you will have in our %3$sPRO%4$s version.', 'orbital-go' ), '<a href="'. esc_url($orbital_external_link) . 'documentacion" target="_blank">', '</a>', '<a href="' . esc_html(get_admin_url()) . 'themes.php?page=orbital_lite-licenses">', '</a>' );?>
                        </p>
                        <a class="button button-primary button-hero button-notice" href="<?php echo esc_url($orbital_external_link); ?>orbital-pro/" data-name="" data-slug="" target="_blank"><?php esc_html_e('Get Orbital PRO now', 'orbital-go') ?></a>

                    </div>
                </div>
            </div>
            <?php
        }
}

add_action( 'admin_init', array( 'PAnD', 'init' ) );
add_action('admin_notices', 'orbital_free_admin_notice');