<?php

final class Orbital_Export_Import_Control extends WP_Customize_Control
{

	protected function render_content()
	{
		?>
		<span class="customize-control-title">
			<?php esc_html_e('Export', 'orbital-go'); ?>
		</span>
		<span class="description customize-control-description">
			<?php esc_html_e('Click the button below to export the customization settings for this theme.', 'orbital-go'); ?>
		</span>
		<input type="button" class="button" name="orbital-ei-export-button" value="<?php esc_attr_e('Export', 'orbital-go'); ?>" />

		<hr class="orbital-ei-hr" />

		<span class="customize-control-title">
			<?php esc_html_e('Import', 'orbital-go'); ?>
		</span>
		<span class="description customize-control-description">
			<?php esc_html_e('Upload a file to import customization settings for this theme.', 'orbital-go'); ?>
		</span>
		<div class="orbital-ei-import-controls">
			<input type="file" name="orbital-ei-import-file" class="orbital-ei-import-file" />
			<label class="orbital-ei-import-images">
				<input type="checkbox" name="orbital-ei-import-images" value="1" /> <?php esc_html_e('Download and import image files?', 'orbital-go'); ?>
			</label>
			<?php wp_nonce_field('orbital-ei-importing', 'orbital-ei-import'); ?>
		</div>
		<div class="orbital-ei-uploading"><?php esc_html_e('Uploading...', 'orbital-go'); ?></div>
		<input type="button" class="button" name="orbital-ei-import-button" value="<?php esc_attr_e('Import', 'orbital-go'); ?>" />
		<?php
	}
}