<?php

//GOOGLE FONTS SCRIPT
function orbital_fonts_head() {
    ?>
    <style>
    <?php
    if (orbital_customize_option('orbital_typo_headings')) {
        $heading = explode(':', orbital_customize_option('orbital_typo_headings'));
        ?>
            h1,h2,h3,h4,h5,h6, .title {
                font-family: '<?php echo esc_html($heading[0]); ?>', sans-serif;
                font-weight: <?php echo esc_html($heading[1]); ?>;
            }
        <?php
    }
    if (orbital_customize_option('orbital_typo_body')) {
        $body = explode(':', orbital_customize_option('orbital_typo_body'));
        ?>
            body, .site-header {
                font-family: '<?php echo esc_html($body[0]); ?>' , sans-serif;
                font-weight: <?php echo esc_html($body[1]); ?>;
            }
        <?php
    }
    if (orbital_customize_option('orbital_typo_logo')) {
        $logo = explode(':', orbital_customize_option('orbital_typo_logo'));
        ?>
            .site-logo a {
                font-family: '<?php echo esc_html($logo[0]); ?>' , sans-serif;
                font-weight: <?php echo esc_html($logo[1]); ?>;
            }
        <?php
    }
    ?>
    </style>
    <?php
}

function orbital_customize_css() {

    $container = orbital_customize_option('orbital_layout_container') ? orbital_customize_option('orbital_layout_container') : 'inherit';
    $relation = orbital_customize_option('orbital_layout_relation') ? orbital_customize_option('orbital_layout_relation') : 0;
    $order = orbital_customize_option('orbital_layout_sidebar_order') ? orbital_customize_option('orbital_layout_sidebar_order') : 0;
    ?>
    <style>
        @media(min-width: 48rem){

            .container {
                width: <?php print esc_html($container); ?>rem;
            }

            .entry-content {
                max-width: <?php print 100 - esc_html($relation); ?>%;
                flex-basis: <?php print 100 - esc_html($relation); ?>%;
            }

            .entry-aside {
                max-width: <?php print esc_html($relation); ?>%;
                flex-basis: <?php print esc_html($relation); ?>%;
                order: <?php echo esc_html($order); ?>;
                -ms-flex-order: <?php echo esc_html($order); ?>;

            }

        }


    <?php if (orbital_customize_option('orbital_link_color')) : ?>
            a {
                color: <?php echo esc_html(orbital_customize_option('orbital_link_color')); ?>;
            }

        <?php endif; ?>


    <?php if (orbital_customize_option('orbital_navbar_background')) : ?>
            .site-header {
                background-color: <?php echo esc_html(orbital_customize_option('orbital_navbar_background')); ?>;
            }

        <?php endif; ?>

    <?php if (orbital_customize_option('orbital_navbar_link_color')) : ?>
            .site-header a {
                color: <?php echo esc_html(orbital_customize_option('orbital_navbar_link_color')); ?>;
            }

            .site-nav-trigger span:before, .site-nav-trigger span:after, .site-nav-trigger span {
                background-color: <?php echo esc_html(orbital_customize_option('orbital_navbar_link_color')); ?>;
            }

            @media(min-width: 1040px){
                .site-navbar .menu-item-has-children:after {
                    border-color: <?php echo esc_html(orbital_customize_option('orbital_navbar_link_color')); ?>;
                }
            }
    <?php endif; ?>


    </style>

        <?php
    }
    