<?php

function orbital_customizer_styles() {
    ?>
    <style>
        .customize-control-title-misc {
            margin: 0;
            font-size: 24px;
            padding-top: 25px;
        }

        .customize-separator {
            border-top: 2px solid #000;
        }

        .customize-multiselect{
            padding: 0.8rem 1rem;
            border: 1px solid #c9bdbd;
            background: #e7e7e7;
        }

        .in-sub-panel #customize-theme-controls .customize-pane-child.current-panel-parent,
        #customize-theme-controls .customize-pane-child.current-section-parent {
            -webkit-transform: translateX(-100%);
            -ms-transform: translateX(-100%);
            transform: translateX(-100%);
        }


    </style>
    <?php
}

add_action('customize_controls_print_styles', 'orbital_customizer_styles', 999);

if (class_exists('WP_Customize_Control') && !class_exists('orbital_Customize_Misc_Control')) {

    class orbital_Customize_Misc_Control extends WP_Customize_Control {

        public $settings = 'blogname';
        public $description = '';
        public $label = '';

        public function render_content() {
            switch ($this->type) {
                default:
                case 'text':
                    echo '<p class="description">' . esc_html($this->description) . '</p>';
                    break;

                case 'multiselect':
                    if (empty($this->choices)) {
                        return;
                    }
                    ?>

                    <script>
                        // Holds the status of whether or not the rest of the code should be run
                        var cstmzr_multicat_js_run = true;

                        (function ($) {

                            // Prevents code from running twice due to live preview window.load firing in addition to the main customizer window.
                            if (true == cstmzr_multicat_js_run) {
                                cstmzr_multicat_js_run = false;
                            } else {
                                return;
                            }


                            /** FREE VERSION DISABLE ELEMENTS **/
                            var disabled_text = '<span class="pro-version" style="color:red"> (PRO) </span>';
                            var disabled_settings = [
                                //minify checkboxes
                                '#_customize-input-orbital_performance_render_blocking_css',
                                '#_customize-input-orbital_performance_render_blocking_js',
                                '#_customize-input-orbital_performance_render_blocking_jquery',
                                '#_customize-input-orbital_performance_lazy_load',
                            ];
                            var disabled_panels = [
                                //GDPR options
                                '#accordion-panel-orbital_gdpr',
                                '#accordion-section-orbital_gdpr_general',
                                '#accordion-section-orbital_gdpr_strictly_necessary',
                                '#accordion-section-orbital_gdpr_functional',
                                '#accordion-section-orbital_gdpr_performance',
                                '#accordion-section-orbital_gdpr_analytics_ads',
                                '#accordion-section-orbital_gdpr_other',
                                '#accordion-panel-orbital_ads',
                                '#accordion-panel-social_panel',
                                '#accordion-section-orbital_performance'
                            ];

                            disabled_settings.forEach(function (item, index) {
                                var el = $(item);
                                if (el.attr('disabled') !== 'disabled') {
                                    el.attr("disabled", 'disabled');
                                    el.parent().append(disabled_text);
                                }
                            });

                            disabled_panels.forEach(function (item, index) {
                                var el = $(item);
                                if (el.find('.pro-version').length === 0) {
                                    //if (item !== '#accordion-panel-orbital_gdpr') {
                                    el.css('pointer-events', 'none');
                                    el.css('opacity', '0.7');
                                    //}
                                    el.find('h3').append(disabled_text);
                                }
                            });

                            /** pro version show **/
                            if ($('#accordion-section-orbital_free_section').length > 0) {
                                $('#accordion-section-orbital_free_section').css('display', 'block');
                                $('#accordion-section-orbital_free_section > li').css('display', 'block');

                            }
                            var api = wp.customize;

                            // Loops through each instance of the category checkboxes control.
                            jQuery('.cstmzr-hidden-categories').each(function () {

                                var id = jQuery(this).prop('id');
                                var categoryString = api.instance(id).get();
                                var categoryArray = categoryString.split(',');

                                // Checks/unchecks category checkboxes based on saved data.
                                jQuery('#' + id).closest('li').find('.cstmzr-category-checkbox').each(function () {

                                    var elementID = jQuery(this).prop('id').split('-');

                                    if (jQuery.inArray(elementID[1], categoryArray) < 0) {
                                        jQuery(this).prop('checked', false);
                                    } else {
                                        jQuery(this).prop('checked', true);
                                    }

                                });

                            });

                            // Sets listeners for checkboxes
                            jQuery('.cstmzr-category-checkbox').on('change', function () {

                                var id = jQuery(this).closest('li').find('.cstmzr-hidden-categories').prop('id');
                                var elementID = jQuery(this).prop('id').split('-');
                                if (jQuery(this).prop('checked') == true) {
                                    addCategory(elementID[1], id);
                                } else {
                                    removeCategory(elementID[1], id);
                                }

                            });

                            // Adds category ID to hidden input.
                            function addCategory(catID, controlID) {

                                var categoryString = api.instance(controlID).get();
                                var categoryArray = categoryString.split(',');

                                if ('' == categoryString) {
                                    var delimiter = '';
                                } else {
                                    var delimiter = ',';
                                }

                                // Updates hidden field value.
                                if (jQuery.inArray(catID, categoryArray) < 0) {

                                    wp.customize(controlID, function (value) {
                                        var sm = categoryString + delimiter + catID;

                                        wp.customize(controlID, function (obj) {
                                            obj.set(sm);
                                            $('#' + controlID).val(sm);
                                        });

                                    });

                                }
                            }

                            // Removes category ID from hidden input.
                            function removeCategory(catID, controlID) {

                                var categoryString = api.instance(controlID).get();
                                var categoryArray = categoryString.split(',');
                                var catIndex = jQuery.inArray(catID, categoryArray);

                                if (catIndex >= 0) {

                                    // Removes element from array.
                                    categoryArray.splice(catIndex, 1);

                                    // Creates new category string based on remaining array elements.
                                    var newCategoryString = '';
                                    jQuery.each(categoryArray, function () {
                                        if ('' == newCategoryString) {
                                            var delimiter = '';
                                        } else {
                                            var delimiter = ',';
                                        }
                                        newCategoryString = newCategoryString + delimiter + this;
                                    });


                                    wp.customize(controlID, function (obj) {
                                        obj.set(newCategoryString);
                                        $('#' + controlID).val(newCategoryString);
                                    });

                                }
                            }

                        })(jQuery);
                    </script>
                    <?php
                    echo '<div class="customize-multiselect">';
                    echo '<span class="customize-control-title">' . esc_html($this->label) . '</span>';
                    foreach ($this->choices as $choice => $choiceName) {
                        echo '<label><input type="checkbox" name="category-' . esc_attr($choice) . '" id="category-' . esc_attr($choice) . '" class="cstmzr-category-checkbox"> ' . esc_html($choiceName) . '</label><br>';
                    }
                    ?><input type="hidden" id="<?php echo esc_attr($this->id); ?>" class="cstmzr-hidden-categories" <?php esc_html($this->link()); ?> value="<?php echo esc_attr(sanitize_text_field($this->value())); ?>"><?php
                    echo '</div>';
                    break;
            }
        }

    }

}
