<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


if (class_exists('WP_Customize_Section') && !class_exists('Orbital_Free_Section')) {

    class Orbital_Free_Section extends WP_Customize_Section {

        public $type = 'orbital-go-section';
        public $url = '';
        public $text = '';
        public $id = 'orbital-go-section';

        public function json() {
            $json = parent::json();
            $json['text'] = $this->text;
            $json['url'] = esc_url($this->url);
            $json['id'] = $this->id;
            return $json;
        }

        /**
         * Render content.
         */
        protected function render_template() {
            ?>
            <li id="accordion-section-{{ data.id }}" class="accordion-section control-section-default orbital-go-section control-section-{{ data.type }} cannot-expand accordion-section" style="margin-bottom:15px;text-align:center">
                <h3 class="accordion-section-title" style="border-top: 1px solid #2271B1;border-bottom: 1px solid #2271B1;">
                    <a style="color:#2271B1;text-decoration:none" href="{{{ data.url }}}" target="_blank"><!--{{ data.text }}
                        <br>-->
                        <button type="button" class="button" aria-label="Comprar ahora"  >{{ data.text }}</button>
                    </a>
                </h3>


            </li>
            <?php
        }

    }

}
if (!function_exists('orbital_freeware_customizer')) {

    function orbital_freeware_customizer($wp_customize) {
        $orbital_protocol = "https://";
        $orbital_external_link = $orbital_protocol . "orbitalthemes.net/";


        if (method_exists($wp_customize, 'register_section_type')) {
            $wp_customize->register_section_type('Orbital_Free_Section');
        }

        $wp_customize->add_section(
                new Orbital_Free_Section(
                        $wp_customize,
                        'orbital_free_section',
                        array(
                    'text' => __('More options in the PRO version!', 'orbital-go'),
                    'url' => esc_url($orbital_external_link . 'orbital-pro/'),
                    'type' => 'orbital-go-section',
                    'capability' => 'edit_theme_options',
                    'priority' => 0,
                        )
                )
        );
        $wp_customize->add_setting('setting', array(
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_empty_values')
                );
        $wp_customize->add_control('setting', array(
            'id' => 'id',
            'section' => 'orbital_free_section'
        ));
    }

}