<?php

$orbital_customizer_defaults = array(
    'orbital_link_color' => '#2196f3',
    'orbital_navbar_background' => '#ffffff',
    'orbital_navbar_link_color' => '#000000',
    'orbital_layout_container' => 52,
    'orbital_layout_relation' => 30,
    'orbital_layout_sidebar_order' => 0,
    'orbital_layout_sidebar_sticky' => false,
    'orbital_layout_menu_orbital' => false,
    'orbital_layout_search_navbar' => false,
    'orbital_typo_logo' => false,
    'orbital_typo_headings' => false,
    'orbital_typo_body' => false,
    'orbital_loop_columns' => 'column-third',
    'orbital_loop_thumbnail' => true,
    'orbital_loop_excerpt' => true,
    'orbital_loop_excerpt_lenght' => 12,
    'orbital_loop_read_more' => esc_html__('Read more', 'orbital-go'),
    'orbital_loop_date' => true,
    'orbital_loop_category' => true,
    'orbital_loop_author' => false,
    'orbital_loop_cluster_img_width' => 390,
    'orbital_loop_cluster_img_height' => 200,
    'orbital_cluster_columns' => 'column-third',
    'orbital_posts_default_thumbnail' => true,
    'orbital_posts_default_related' => true,
    'orbital_posts_show_category' => true
);

function orbital_customizer_sections() {

    $sections = array(
        //Sections
        array(
            'name' => 'orbital_layout',
            'title' => __('Layout Settings', 'orbital-go'),
            'priority' => 1001,
        ),
        array(
            'name' => 'orbital_posts',
            'title' => __('Posts Settings', 'orbital-go'),
            'priority' => 1001,
        ),
        array(
            'name' => 'orbital_typo',
            'title' => __('Typography Settings', 'orbital-go'),
            'priority' => 1001,
        ),
        array(
            'name' => 'orbital_loop',
            'title' => __('Loops Settings', 'orbital-go'),
            'priority' => 1002,
        )
    );

    return $sections;
}

function orbital_customizer_settings() {
    global $orbital_customizer_defaults;
    $settings = array(
        //
        //  COLORS
        //

        array(
            'name' => 'orbital_link_color',
            'default' => $orbital_customizer_defaults['orbital_link_color'],
            'transport' => 'postMessage',
            'sanitize_callback' => 'orbital_sanitize_hex_color',
        ),
        array(
            'name' => 'orbital_navbar_background',
            'default' => $orbital_customizer_defaults['orbital_navbar_background'],
            'transport' => 'postMessage',
            'sanitize_callback' => 'orbital_sanitize_hex_color',
        ),
        array(
            'name' => 'orbital_navbar_link_color',
            'default' => $orbital_customizer_defaults['orbital_navbar_link_color'],
            'transport' => 'postMessage',
            'sanitize_callback' => 'orbital_sanitize_hex_color',
        ),
        //
        //  LAYOUT SETTINGS
        //
        array(
            'name' => 'orbital_layout_container',
            'default' => $orbital_customizer_defaults['orbital_layout_container'],
            'transport' => 'postMessage',
            'sanitize_callback' => 'orbital_sanitize_number_absint',
        ),
        array(
            'name' => 'orbital_layout_relation',
            'default' => $orbital_customizer_defaults['orbital_layout_relation'],
            'transport' => 'postMessage',
            'sanitize_callback' => 'orbital_sanitize_number_absint',
        ),
        array(
            'name' => 'orbital_layout_sidebar_order',
            'default' => $orbital_customizer_defaults['orbital_layout_sidebar_order'],
            'transport' => 'postMessage',
            'sanitize_callback' => 'orbital_sanitize_number_absint',
        ),
        array(
            'name' => 'orbital_layout_sidebar_sticky',
            'default' => $orbital_customizer_defaults['orbital_layout_sidebar_sticky'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_empty_values',
        ),
        array(
            'name' => 'orbital_layout_search_navbar',
            'default' => $orbital_customizer_defaults['orbital_layout_search_navbar'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_empty_values',
        ),
        array(
            'name' => 'orbital_layout_menu_orbital',
            'default' => $orbital_customizer_defaults['orbital_layout_menu_orbital'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_empty_values',
        ),
        //
        // POSTS SETTINGS
        //
        array(
            'name' => 'orbital_posts_default_thumbnail',
            'default' => $orbital_customizer_defaults['orbital_posts_default_thumbnail'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_empty_values',
        ),
        array(
            'name' => 'orbital_posts_default_related',
            'default' => $orbital_customizer_defaults['orbital_posts_default_related'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_empty_values',
        ),
        array(
            'name' => 'orbital_posts_show_category',
            'default' => $orbital_customizer_defaults['orbital_posts_show_category'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_empty_values',
        ),
        //
        //TYPO SETTINGS
        //
        array(
            'name' => 'orbital_typo_logo',
            'default' => $orbital_customizer_defaults['orbital_typo_logo'],
            'transport' => 'postMessage',
            'sanitize_callback' => 'orbital_sanitize_nohtml',
        ),
        array(
            'name' => 'orbital_typo_headings',
            'default' => $orbital_customizer_defaults['orbital_typo_headings'],
            'transport' => 'postMessage',
            'sanitize_callback' => 'orbital_sanitize_nohtml',
        ),
        array(
            'name' => 'orbital_typo_body',
            'default' => $orbital_customizer_defaults['orbital_typo_body'],
            'transport' => 'postMessage',
            'sanitize_callback' => 'orbital_sanitize_nohtml',
        ),
        //
        // LOOP SETTINGS
        //
        array(
            'name' => 'orbital_loop_thumbnail',
            'default' => $orbital_customizer_defaults['orbital_loop_thumbnail'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_checkbox',
        ),
        array(
            'name' => 'orbital_loop_excerpt',
            'default' => $orbital_customizer_defaults['orbital_loop_excerpt'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_checkbox',
        ),
        array(
            'name' => 'orbital_loop_excerpt_lenght',
            'default' => $orbital_customizer_defaults['orbital_loop_excerpt_lenght'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_number_absint',
        ),
        array(
            'name' => 'orbital_loop_read_more',
            'default' => $orbital_customizer_defaults['orbital_loop_read_more'],
            'transport' => 'postMessage',
            'sanitize_callback' => 'orbital_sanitize_checkbox',
        ),
        array(
            'name' => 'orbital_loop_date',
            'default' => $orbital_customizer_defaults['orbital_loop_date'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_checkbox',
        ),
        array(
            'name' => 'orbital_loop_category',
            'default' => $orbital_customizer_defaults['orbital_loop_category'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_checkbox',
        ),
        array(
            'name' => 'orbital_loop_author',
            'default' => $orbital_customizer_defaults['orbital_loop_author'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_checkbox',
        ),
        array(
            'name' => 'orbital_loop_cluster_img_width',
            'default' => $orbital_customizer_defaults['orbital_loop_cluster_img_width'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_number_absint',
        ),
        array(
            'name' => 'orbital_loop_cluster_img_height',
            'default' => $orbital_customizer_defaults['orbital_loop_cluster_img_height'],
            'transport' => 'refresh',
            'sanitize_callback' => 'orbital_sanitize_number_absint',
        )
    );


    return $settings;
}

function orbital_customizer_controls($fonts) {
    $controls = array(
        //
        //  COLOR CONTROLS
        //

        array(
            'setting' => 'orbital_link_color',
            'info' => array(
                'label' => __('Link Color', 'orbital-go'),
                'section' => 'colors',
                'settings' => 'orbital_link_color',
                'type' => 'color',
            )
        ),
        array(
            'setting' => 'orbital_navbar_background',
            'info' => array(
                'label' => __('Navbar Background Color', 'orbital-go'),
                'section' => 'colors',
                'settings' => 'orbital_navbar_background',
                'type' => 'color',
            )
        ),
        array(
            'setting' => 'orbital_navbar_link_color',
            'info' => array(
                'label' => __('Navbar Link Color', 'orbital-go'),
                'section' => 'colors',
                'settings' => 'orbital_navbar_link_color',
                'type' => 'color',
            )
        ),
        //
        //  LAYOUT CONTROLS
        //
        array(
            'setting' => 'orbital_layout_container',
            'info' => array(
                'label' => __('Container Width', 'orbital-go'),
                'section' => 'orbital_layout',
                'settings' => 'orbital_layout_container',
                'type' => 'range',
                'input_attrs' => array(
                    'min' => 36,
                    'max' => 96,
                    'step' => 0.5,
                ),
            )
        ),
        array(
            'setting' => 'orbital_layout_relation',
            'info' => array(
                'label' => __('Content-Sidebar Relation', 'orbital-go'),
                'section' => 'orbital_layout',
                'settings' => 'orbital_layout_relation',
                'type' => 'range',
                'input_attrs' => array(
                    'min' => 25,
                    'max' => 50,
                    'step' => 0.5,
                ),
            )
        ),
        array(
            'setting' => 'orbital_layout_sidebar_order',
            'info' => array(
                'type' => 'select',
                'section' => 'orbital_layout',
                'label' => __('Sidebar Order', 'orbital-go'),
                'settings' => 'orbital_layout_sidebar_order',
                'choices' => array(
                    -1 => 'Left',
                    0 => 'Right',
                ),
            )),
        array(
            'setting' => 'orbital_layout_sidebar_sticky',
            'info' => array(
                'label' => __('Sticky Sidebar', 'orbital-go'),
                'section' => 'orbital_layout',
                'settings' => 'orbital_layout_sidebar_sticky',
                'type' => 'checkbox',
            )
        ),
        array(
            'setting' => 'orbital_layout_search_navbar',
            'info' => array(
                'label' => __('Navbar Search', 'orbital-go'),
                'section' => 'orbital_layout',
                'settings' => 'orbital_layout_search_navbar',
                'type' => 'checkbox',
            )
        ),
        array(
            'setting' => 'orbital_layout_menu_orbital',
            'info' => array(
                'label' => __('Orbital Menu', 'orbital-go'),
                'section' => 'orbital_layout',
                'settings' => 'orbital_layout_menu_orbital',
                'type' => 'checkbox',
            )
        ),
        //
        //  POSTS CONTROLS
        //
        array(
            'setting' => 'orbital_posts_default_thumbnail',
            'info' => array(
                'label' => __('Show Thumbnails', 'orbital-go'),
                'section' => 'orbital_posts',
                'settings' => 'orbital_posts_default_thumbnail',
                'type' => 'checkbox',
            )
        ),
        array(
            'setting' => 'orbital_posts_default_related',
            'info' => array(
                'label' => __('Show Related Posts', 'orbital-go'),
                'section' => 'orbital_posts',
                'settings' => 'orbital_posts_default_related',
                'type' => 'checkbox',
            )
        ),
        array(
            'setting' => 'orbital_posts_show_category',
            'info' => array(
                'label' => __('Show Category Link', 'orbital-go'),
                'section' => 'orbital_posts',
                'settings' => 'orbital_posts_show_category',
                'type' => 'checkbox',
            )
        ),
        //
        // LOOPS CONTROLS
        //
        array(
            'setting' => 'orbital_loop_thumbnail',
            'info' => array(
                'label' => __('Show Thumbnails', 'orbital-go'),
                'section' => 'orbital_loop',
                'settings' => 'orbital_loop_thumbnail',
                'type' => 'checkbox',
            )
        ),
        array(
            'setting' => 'orbital_loop_excerpt',
            'info' => array(
                'label' => __('Show Excerpt', 'orbital-go'),
                'section' => 'orbital_loop',
                'settings' => 'orbital_loop_excerpt',
                'type' => 'checkbox',
            )
        ),
        array(
            'setting' => 'orbital_loop_date',
            'info' => array(
                'label' => __('Show Date', 'orbital-go'),
                'section' => 'orbital_loop',
                'settings' => 'orbital_loop_date',
                'type' => 'checkbox',
            )
        ),
        array(
            'setting' => 'orbital_loop_category',
            'info' => array(
                'label' => __('Show Category', 'orbital-go'),
                'section' => 'orbital_loop',
                'settings' => 'orbital_loop_category',
                'type' => 'checkbox',
            )
        ),
        array(
            'setting' => 'orbital_loop_author',
            'info' => array(
                'label' => __('Show Author', 'orbital-go'),
                'section' => 'orbital_loop',
                'settings' => 'orbital_loop_author',
                'type' => 'checkbox',
            )
        ),
        array(
            'setting' => 'orbital_loop_excerpt_lenght',
            'info' => array(
                'label' => __('Excerpt Length', 'orbital-go'),
                'section' => 'orbital_loop',
                'settings' => 'orbital_loop_excerpt_lenght',
                'type' => 'number',
                'input_attrs' => array(
                    'min' => 5,
                ),
            )
        ),
        array(
            'setting' => 'orbital_loop_columns',
            'info' => array(
                'type' => 'select',
                'section' => 'orbital_loop',
                'label' => __('Number of columns', 'orbital-go'),
                'settings' => 'orbital_loop_columns',
                'choices' => array(
                    'column' => 'List Mode',
                    'column-half' => '2 columns',
                    'column-third' => '3 columns',
                    'column-quarter' => '4 columns',
                ),
            )),
        array(
            'setting' => 'orbital_loop_read_more',
            'info' => array(
                'label' => __('Read More Text', 'orbital-go'),
                'section' => 'orbital_loop',
                'settings' => 'orbital_loop_read_more',
                'type' => 'text',
            )
        ),
        array(
            'setting' => 'orbital_loop_cluster_img_width',
            'info' => array(
                'label' => __('Cluster Image Width', 'orbital-go'),
                'description' => __('All miniatures need to be regenerated', 'orbital-go'),
                'section' => 'orbital_loop',
                'settings' => 'orbital_loop_cluster_img_width',
                'type' => 'number',
                'input_attrs' => array(
                    'min' => 1,
                ),
            )
        ),
        array(
            'setting' => 'orbital_loop_cluster_img_height',
            'info' => array(
                'label' => __('Cluster Image Height', 'orbital-go'),
                'description' => __('All miniatures need to be regenerated', 'orbital-go'),
                'section' => 'orbital_loop',
                'settings' => 'orbital_loop_cluster_img_height',
                'type' => 'number',
                'input_attrs' => array(
                    'min' => 1,
                ),
            )
        ),
        //
        // TYPO CONTROLS
        //
        array('setting' => 'orbital_typo_logo',
            'info' => array(
                'label' => __('Typo Logo', 'orbital-go'),
                'description' => __('You can enter a URL. For example from Google Fonts.', 'orbital-go'),
                'section' => 'orbital_typo',
                'settings' => 'orbital_typo_logo',
                'type' => 'select',
                'choices' => $fonts,
            )
        ),
        array('setting' => 'orbital_typo_headings',
            'info' => array(
                'label' => __('Typo Headings', 'orbital-go'),
                'description' => __('You can enter a URL. For example from Google Fonts.', 'orbital-go'),
                'section' => 'orbital_typo',
                'settings' => 'orbital_typo_headings',
                'type' => 'select',
                'choices' => $fonts,
            )
        ),
        array('setting' => 'orbital_typo_body',
            'info' => array(
                'label' => __('Typo Body', 'orbital-go'),
                'description' => __('You can enter a URL. For example from Google Fonts.', 'orbital-go'),
                'section' => 'orbital_typo',
                'settings' => 'orbital_typo_body',
                'type' => 'select',
                'choices' => $fonts,
            )
        )
    );
    return $controls;
}
