<?php
/**
 * Update Theme System
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package WordPress
 * @subpackage Orbital Go
 * @since 1.0
 */
if (!class_exists('Wp_License_Manager_Client')) {

    class Wp_License_Manager_Client {

        private $api_endpoint;
        private $product_id;
        private $product_name;
        private $type;
        private $text_domain;
        private $plugin_file;

        public function __construct(
                $product_id,
                $product_name,
                $type = 'theme',
                $plugin_file = ''
        ) {
            $this->product_id = $product_id;
            $this->product_name = $product_name;
            $this->type = $type;
            $this->plugin_file = $plugin_file;


            if (is_admin()) {
                add_action('admin_menu', array($this, 'add_license_settings_page'));
                add_action('admin_init', array($this, 'add_license_settings_fields'));
            }

        }

        public function add_license_settings_page() {
            $title = esc_html__('About Orbital', 'orbital-go');
            add_theme_page(
                    $title,
                    $title,
                    'read',
                    $this->get_settings_page_slug(),
                    array($this, 'render_licenses_menu')
            );
        }

        public function add_license_settings_fields() {
            $settings_group_id = $this->product_id . '-license-settings-group';
            $settings_section_id = $this->product_id . '-license-settings-section';
            register_setting($settings_group_id, $this->get_settings_field_name());
        }

        public function render_compare_table() {
            ?>
            <style>
                .licence-compare {
                    text-align: center;
                    width: 700px;
                    font-size: 16px;
                    margin-top:25px;
                }
                .licence-compare th {
                    background-color: #4472c4;
                    color:white;
                }
                .licence-compare th, .licence-compare td {
                    padding:10px;
                }
                .licence-compare tr:nth-child(odd) {
                    background-color: #ededed;
                }
                .licence-compare tr{
                    background-color: #dae3f3;

                }
                .ok, .ko {
                    font-size:22px;
                }
                .ok {
                    color:green;
                }
                .ko {
                    color:red;
                }
            </style>
            <table class="licence-compare">
                <tr style="background-color:transparent;">
                    <th style="background-color:transparent;"></th>
                    <th><?php echo esc_html__('Orbital Go', 'orbital-go') ?></th>
                    <th>ORBITAL PRO</th>
                </tr>
                <tr>
                    <td><?php echo esc_html__('Customisation of header, background and menu colours', 'orbital-go') ?></td>
                    <td><span class="ok">&#10004;</span></td>
                    <td><span class="ok">&#10004;</span></td>
                </tr>
                <tr>
                    <td><?php echo esc_html__('Header and background image', 'orbital-go') ?></td>
                    <td><span class="ok">&#10004;</span></td>
                    <td><span class="ok">&#10004;</span></td>
                </tr>
                <tr>
                    <td><?php echo esc_html__('Orbital Menu', 'orbital-go') ?></td>
                    <td><span class="ok">&#10004;</span></td>
                    <td><span class="ok">&#10004;</span></td>
                </tr>
                <tr>
                    <td><?php echo esc_html__('Customisation of displays and fonts', 'orbital-go') ?></td>
                    <td><span class="ok">&#10004;</span></td>
                    <td><span class="ok">&#10004;</span></td>
                </tr>
                <tr>
                    <td><?php echo esc_html__('Integrated RRSS plugin', 'orbital-go') ?></td>
                    <td><span class="ko">&#10006;</span></td>
                    <td><span class="ok">&#10004;</span></td>
                </tr>
                <tr>
                    <td><?php echo esc_html__('PageSpeed Optimisation', 'orbital-go') ?></td>
                    <td><span class="ko">&#10006;</span></td>
                    <td><span class="ok">&#10004;</span></td>
                </tr>
                <tr>
                    <td><?php echo esc_html__('Integrated GDPR Cookies Plugin', 'orbital-go') ?></td>
                    <td><span class="ko">&#10006;</span></td>
                    <td><span class="ok">&#10004;</span></td>
                </tr>
                <tr>
                    <td><?php echo esc_html__('Cluster', 'orbital-go') ?></td>
                    <td><span class="ko">&#10006;</span></td>
                    <td><span class="ok">&#10004;</span></td>
                </tr>
                 <tr>
                    <td><?php echo esc_html__('Support', 'orbital-go') ?></td>
                    <td><span class="ko">&#10006;</span></td>
                    <td><span class="ok">&#10004;</span></td>
                </tr>


            </table>
            <?php
        }

        public function render_licenses_menu() {
            /* translators: %s: Theme name */
            $title = __('About Orbital', 'orbital-go');
            $settings_group_id = $this->product_id . '-license-settings-group';
            $orbital_protocol = "https://";
            $orbital_external_link = $orbital_protocol . "orbitalthemes.net/";
            ?>
            <div class="wrap">
                <h2><?php echo esc_html($title); ?></h2>
                <p><?php esc_html_e('The Lite version of Orbital is active. If you want the PRO version,', "orbital-go"); ?> <a target="_blank" href="<?php echo esc_url($orbital_external_link); ?>orbital-pro/"><?php esc_html_e('click here', 'orbital-go') ?></a>.</p>

                <?php $this->render_compare_table(); ?>
            </div>
            <?php
        }


        protected function get_settings_field_name() {
            return $this->product_id . '-license-settings';
        }

        protected function get_settings_page_slug() {
            return $this->product_id . '-licenses';
        }

        private function is_theme() {
            return $this->type == 'theme';
        }

        private function get_local_version() {
            if ($this->is_theme()) {
                $theme_data = wp_get_theme();
                return $theme_data->Version;
            } else {
                $plugin_data = get_plugin_data($this->plugin_file, false);
                return $plugin_data['Version'];
            }
        }

        private function get_license_key() {
            $license_email = ( defined('FOURBASE_LICENSE_EMAIL') ) ? FOURBASE_LICENSE_EMAIL : '';
            $license_key = ( defined('FOURBASE_LICENSE_KEY') ) ? FOURBASE_LICENSE_KEY : '';
            if (!$license_key || strlen($license_key) < 8) {
                $options = get_option($this->get_settings_field_name());
                if ($options && isset($options['email']) && isset($options['license_key']) && strlen($options['email']) > 0 && strlen($options['license_key']) >= 8) {
                    $license_email = $options['email'];
                    $license_key = $options['license_key'];
                } else {
                    $license_email = '';
                    $license_key = '';
                }
            }

            if (strlen($license_email) > 0 && strlen($license_key) >= 8) {
                return array('key' => $license_key, 'email' => $license_email);
            }
            return false;
        }

        private function call_api($action, $params) {
            $url = $this->api_endpoint . '/' . $action;
            $url .= '?' . http_build_query($params);
            $response = wp_remote_get($url);
            if (is_wp_error($response)) {
                return false;
            }
            $response_body = wp_remote_retrieve_body($response);
            $result = json_decode($response_body);

            return $result;
        }

        private function is_api_error($response) {
            if ($response === false) {
                return true;
            }
            if (!is_object($response)) {
                return true;
            }
            if (isset($response->error)) {
                return true;
            }
            return false;
        }

    }

}
$licence_manager = new Wp_License_Manager_Client(
        'orbital_lite',
        'orbital_lite',
        null,
        'theme'
);