<?php
/**
 * All hooks from Orbital
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package WordPress
 * @subpackage Orbital Go
 * @since 1.0
 */

//Page
add_action('orbital_before_page_content', 'orbital_yoast_breadcrumbs', 10);
add_action('orbital_before_page_content', 'orbital_thumbnail_post', 10);

//Single
add_action('orbital_before_single_content', 'orbital_yoast_breadcrumbs', 10);
add_action('orbital_before_single_content', 'orbital_thumbnail_post', 10);
add_action('orbital_before_single_comments', 'orbital_related_posts', 10);

//Yoast Filters
add_action('wpseo_register_extra_replacements', 'orbital_title_replacements');

//WP Gallery
add_filter('attachment_fields_to_edit', 'orbital_attachment_custom_link', 10, 2);
add_filter('attachment_fields_to_save', 'orbital_attachment_custom_link_save', 10, 2);
add_action('print_media_templates', 'orbital_gallery_settings');

//MetaBox
add_action('add_meta_boxes', 'orbital_add_meta_boxes');
add_action('admin_footer', 'orbital_admin_footer');
add_action('save_post', 'orbital_save_post');

//Json-ld
add_action('wp_footer', 'orbital_markup_site');

//Jetpack
add_action('after_setup_theme', 'orbital_jetpack_setup');

add_filter('comment_text_rss', 'wp_filter_nohtml_kses');
add_filter('comment_excerpt', 'wp_filter_nohtml_kses');

//Extra Options
add_filter('excerpt_length', 'orbital_excerpt_length', 999);
add_filter('excerpt_more', 'orbital_excerpt_more');
add_filter('mce_buttons', 'orbital_next_page', 1, 2);
add_filter('body_class', 'orbital_check_sidebar_class');
add_filter('get_custom_logo', 'orbital_customize_logo_html');
add_action('init', 'orbital_excerpts_to_pages');
add_action('edit_category', 'orbital_category_transient_flusher');
add_action('save_post', 'orbital_category_transient_flusher');
add_action('admin_head', 'orbital_add_custom_buttons');
add_filter('post_class', 'orbital_remove_hentry');
add_filter('edit_category_form_fields', 'orbital_cat_description');
add_action('edited_category', 'orbital_save_extra_category_fields');
add_filter('comment_form_defaults', 'orbital_comment_textarea');