<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
?>

	<?php get_header(); ?>

	<?php orbit_get_sidebar( 'left' ) ?>

	<div id="content" class="content-index">

		<?php if ( have_posts() ): ?>
			<div class="entry-content search-page">
				<?php get_search_form(); ?>
			</div><!-- .entry-content -->
			<p class="resultsearch"><?php printf( __( 'Search Results for: %s', 'orbit' ), '<span>"' . get_search_query() . '"</span>' ); ?></p>
		<?php while ( have_posts() ) : the_post(); ?>
			<?php get_template_part( 'content', 'excerpt' ); ?>
		<?php endwhile; ?>
			<?php get_template_part( 'content', 'navigation' ); ?>
		<?php else : ?>
			<article>
				<p class="resultsearch"><?php _e( 'No results found for ', 'orbit' ); ?> <?php echo '<span>"' . get_search_query() . '"</span>'; ?></p>
			</article>
			<div class="entry-content search-page">
				<p><?php _e( 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'orbit' ); ?></p>
				<?php get_search_form(); ?>
			</div><!-- .entry-content -->
		<?php endif; ?>

	</div>	<!-- end content -->

	<?php orbit_get_sidebar( 'rigth' ) ?>

	<?php get_footer(); ?>
