<?php
/**
 * Orbit insert in tempalte style and script for custom options
 *
 * @package Orbit
 * @since Orbit 1.1.0
 */

/**
 * Insert custom styles css in head
 *
 * @since Orbit 1.0.0
 */
function orbit_custom_styles() {

	$custom_styles = orbit_is_changed_custom_style();

	if ( $custom_styles['changed_style'] ) {
?>
		<style type="text/css">
			<?php if ( $custom_styles['changed_title'] ): ?>
				.dropdown ul, h1, h2, h3, h4, h5, h6, h1 a, h2 a, h3 a, h4 a, h5 a, h6 a, .breadcrumb p {
					font-family: <?php echo $custom_styles['font_title']; ?>;
				}
			<?php endif; ?>
			<?php if ( $custom_styles['changed_base'] ): ?>
				body, article .edit-link a {
					font-family: <?php echo $custom_styles['font_base']; ?>;
				}
			<?php endif; ?>
			
			<?php if ( $custom_styles['color_title_main'] ): ?>
				article h1, article h1 a {
					color: <?php echo $custom_styles['color_title_main']; ?>;
				}
				.content-page article h1, .content-page article h1 a {
					color: #333;
				}
			<?php endif; ?>

			<?php if ( $custom_styles['color_title_seconds'] ): ?>
				article h2, article h2 a, article h3, article h3 a, article h4, article h4 a, article h5, article h5 a, article h6, article h6 a {
					color: <?php echo $custom_styles['color_title_seconds']; ?>;
				}
				.content-page article h2, .content-page article h2 a, .content-page article h3, .content-page article h3 a, .content-page article h4, .content-page article h4 a, .content-page article h5, .content-page article h5 a, .content-page article h6, .content-page article h6 a {
					color: #333;
				}
				#reply-title, .comment-text h3, .comment-text h3 a, .header-comment h3 a, .header-comment h3, .title-comments h2 { color:#333;}
			<?php endif; ?>
			
			<?php  if ( $custom_styles['color_scheme'] != '' ) {
				$hex_scheme = array( 'orange_dark'	 => '#fa6900',
									 'orange_ligth'	 => '#ff9140',
									 'orange_border'  => '#ff9140',
									 'green_dark'  => '#17a363',
									 'green_ligth' => '#31ba7c',
									 'green_border'	 => '#19b23b' );

				$primary_color = $hex_scheme[$custom_styles['color_scheme'] . '_dark'];
				$secundary_color = $hex_scheme[$custom_styles['color_scheme'] . '_ligth'];
				$boder_color = $hex_scheme[$custom_styles['color_scheme'] . '_border'];
			?>

				#top-header {
					border-top: 6px solid <?php echo $primary_color; ?>;
				}
				.top-header-without-breadcrumb {
					border-bottom: 4px solid <?php echo $primary_color; ?>;
				}
				#main-footer {
					background-color: <?php echo $primary_color; ?>;
					background-repeat: no-repeat;
					background-image: -webkit-gradient(linear, 0 0, 0 100%, from(<?php echo $primary_color; ?>), color-stop(0.5, <?php echo $primary_color; ?>), to(<?php echo $secundary_color; ?>));
					background-image: -webkit-linear-gradient(<?php echo $primary_color; ?>, color-stop(0.5, <?php echo $primary_color; ?>), <?php echo $secundary_color; ?>);
					background-image: -moz-linear-gradient(<?php echo $primary_color; ?>, color-stop(<?php echo $primary_color; ?>, 0.5), <?php echo $secundary_color; ?>);
				}
				article .edit-link a, .navigation .current, .breadcrumb p {
					background-color: <?php echo $primary_color; ?>;
				}
				.breadcrumb p, #main-footer {
					border: 1px solid <?php echo $boder_color; ?>;
				}
			<?php
				}
				if ( $custom_styles['css_user'] != '' ) {
					echo $custom_styles['css_user'];
				}
			?>
		</style>
<?php
	}
}
add_action( 'wp_head', 'orbit_custom_styles' ,8 );

/**
 * Insert javascript in line
 *
 * tinyNav -> responsive menu
 * flexslider -> responsive image slider
 *
 * @since Orbit 1.0.0
 */
function orbit_custom_script() {
?>
<script type="text/javascript">
	jQuery(document).ready(function ($) {

<?php 
	// Flexslider only called in front page
	if ( is_front_page() ) { 
?>
		$(window).load(function() {
			$('.flexslider').flexslider(
				<?php orbit_get_flexslider_setting(); ?>
			);
		});
<?php } ?>
	});
</script>
<?php
}
add_action( 'wp_head', 'orbit_custom_script' ,9 );
?>