<?php
/**
 * Orbit Customize Options
 *
 * @package Orbit
 * @since Orbit 1.2.0
 */

/**
 * Register settings for customize options
 *
 * @since Orbit 1.2.0
 */
function orbit_customize_register_settings( $wp_customize ) {

	// Load class custom controls
    require dirname( __FILE__ ) . '/customizer-controls.php';

	// Default values for settings
	$customize_default = orbit_get_default_theme_options();

	// Creating Section: General
	$wp_customize->add_section(
		'section_general',
		array(
			'title'    => __( 'General', 'orbit' ),
			'priority' => 20,
			'capability' => 'edit_theme_options',
	 	)
 	);
		
	// Section: General -- Setting: color_scheme
	$wp_customize->add_setting(
		'orbit_theme_options[color_scheme]',
		array(
			'default'    		=> $customize_default['color_scheme'],
			'type'       		=> 'option',
			'sanitize_callback' => 'orbit_sanitize_color_scheme'
		)
	);

	// Section: General -- Control: color_scheme
	$wp_customize->add_control(
		new Orbit_Select_Img_Control(
			$wp_customize,
			'orbit_theme_options[color_scheme]',
			array(
				'label'   	=> __( 'Color Scheme', 'orbit' ),
				'section' 	=> 'section_general',
				'settings'  => 'orbit_theme_options[color_scheme]',
				'choices'	=> array(
					'blue'    => '/inc/images/scheme-blue.png',
					'orange'  => '/inc/images/scheme-orange.png',
					'green'   => '/inc/images/scheme-green.png'
				)
			)
		)
	);

	// Section: General -- Setting: theme_layout
	$wp_customize->add_setting(
		'orbit_theme_options[theme_layout]',
		array(
			'default'    		=> $customize_default['theme_layout'],
			'type'      		=> 'option',
			'sanitize_callback' => 'orbit_sanitize_theme_layout'
		)
	);

	// Section: General -- Control: theme_layout
	$wp_customize->add_control(
		new Orbit_Select_Img_Control(
			$wp_customize,
			'orbit_theme_options[theme_layout]',
			array(
				'label'   	=> __( 'Sidebar Position', 'orbit' ),
				'section' 	=> 'section_general',
				'settings'  => 'orbit_theme_options[theme_layout]',
				'choices'	=> array(
					'content-sidebar' => '/inc/images/content-sidebar.png',
					'sidebar-content' => '/inc/images/sidebar-content.png'
				)
			)
		)
	);

	// [Basic] Section: General -- Setting: breadcrumb
	$wp_customize->add_setting(
		'orbit_theme_options[breadcrumb]',
		array(
			'default'    		=> $customize_default['breadcrumb'],
			'type'       		=> 'option',
			'sanitize_callback' => 'orbit_sanitize_checkbox'
		)
	);

	// [Basic] Section: General -- Control: breadcrumb
	$wp_customize->add_control(
		'breadcrumb',
		array(
			'label' 	=> __( 'Show Breadcrumb', 'orbit' ),
			'section' 	=> 'section_general',
			'type' 		=> 'checkbox',
			'settings'  => 'orbit_theme_options[breadcrumb]',
		)
	);

	// [Basic] Section: General -- Setting: show_title_page
	$wp_customize->add_setting(
		'orbit_theme_options[show_title_page]',
		array(
			'default'    		=> $customize_default['show_title_page'],
			'type'       		=> 'option',
			'sanitize_callback' => 'orbit_sanitize_text'
		)
	);

	// [Basic] Section: General -- Control: show_title_page
	$wp_customize->add_control(
		'show_title_page',
		array(
			'label' 	  => __( 'No Display Heading (H1)', 'orbit' ),
			'section' 	  => 'section_general',
			'type' 		  => 'text',
			'description' => __( 'Enter slug pages separated by spaces. Ex: home support', 'orbit' ),
			'settings'    => 'orbit_theme_options[show_title_page]',
		)
	);

	// [Basic] Section: General -- Setting: footer_info
	$wp_customize->add_setting(
		'orbit_theme_options[footer_info]',
		array(
			'default'    		=> $customize_default['footer_info'],
			'type' 			    => 'option',
			'sanitize_callback' => 'orbit_sanitize_text'
		)
	);

	// [Basic] Section: General -- Control: footer_info
	$wp_customize->add_control(
		'footer_info',
		array(
			'label' 	  => __( 'Footer Info', 'orbit' ),
			'section' 	  => 'section_general',
			'type' 		  => 'text',
			'settings'    => 'orbit_theme_options[footer_info]',
		)
	);

	// [Basic] Section: General -- Setting: css_user
	$wp_customize->add_setting(
		'orbit_theme_options[css_user]',
		array(
			'default'    		=> $customize_default['css_user'],
			'type' 			    => 'option',
			'sanitize_callback' => 'orbit_sanitize_text'
		)
	);

	// [Basic] Section: General -- Control: css_user
	$wp_customize->add_control(
		new Orbit_Textarea_Control(
			$wp_customize,
			'orbit_theme_options[css_user]',
			array(
				'label' 	  => __( 'CSS User', 'orbit' ),
				'section' 	  => 'section_general',
				'settings'    => 'orbit_theme_options[css_user]',
			)
		)
	);

	// Creating Section: Post Section
	$wp_customize->add_section(
		'posts_section',
		array(
			'title'    => __( 'Post Options', 'orbit' ),
			'priority' => 21,
			'capability' => 'edit_theme_options',
	 	)
	 	);

	// [Basic] Section: Post -- Setting: pagination
	$wp_customize->add_setting(
		'orbit_theme_options[pagination]',
		array(
			'default'    		=> $customize_default['pagination'],
			'type'       		=> 'option',
			'sanitize_callback' => 'orbit_sanitize_pagination'
		)
	);

	// [Basic] Section: Post -- Control: pagination
	$wp_customize->add_control(
		'pagination',
		array(
			'label' 	=> __( 'Default Pagination Posts', 'orbit' ),
			'section' 	=> 'posts_section',
			'type'      => 'radio',
			'settings'  => 'orbit_theme_options[pagination]',
	            'choices'   => array(
	                'pages'    		=> __( 'Pages posts link', 'orbit' ),
	                'older-newer'   => __( 'Older-newer posts link', 'orbit' ),
	            )
		)
	);

	// [Basic] Section: Posts -- Setting: color_title_main
	$wp_customize->add_setting(
		'orbit_theme_options[color_title_main]',
		array(
			'default'    		=> $customize_default['color_title_main'],
			'type'		        => 'option',
			'sanitize_callback' => 'orbit_sanitize_hex_color',
		)
	);

	// [Basic] Section: Posts -- Control: color_title_main
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'color_title_main',
			array(
				'label'      => __( 'Heading (H1) color', 'orbit' ),
				'section'    => 'posts_section',
				'settings'   => 'orbit_theme_options[color_title_main]',
			)
		)
	);

	// [Basic] Section: Posts -- Setting: color_title_seconds
	$wp_customize->add_setting(
		'orbit_theme_options[color_title_seconds]',
		array(
			'default'    		=> $customize_default['color_title_seconds'],
			'type'       		=> 'option',
			'sanitize_callback' => 'orbit_sanitize_hex_color',
		)
	);

	// [Basic] Section: Posts -- Control: color_title_seconds
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'color_title_seconds',
			array(
				'label'      => __( 'Heading (H2) color', 'orbit' ),
				'section'    => 'posts_section',
				'settings'   => 'orbit_theme_options[color_title_seconds]',
			)
		)
	);
	// [Basic] Section: Posts -- Setting: show_author
	$wp_customize->add_setting(
		'orbit_theme_options[show_author]',
		array(
			'default'    		=> $customize_default['show_author'],
			'type'       		=> 'option',
			'sanitize_callback' => 'orbit_sanitize_checkbox'
		)
	);

	// [Basic] Section: Posts -- Control: show_author
	$wp_customize->add_control(
		'show_author',
		array(
			'label' 	=> __( 'Show Author', 'orbit' ),
			'section' 	=> 'posts_section',
			'type' 		=> 'checkbox',
			'settings'  => 'orbit_theme_options[show_author]',
		)
	);

	// [Basic] Section: Posts -- Setting: show_categories
	$wp_customize->add_setting(
		'orbit_theme_options[show_categories]',
		array(
			'default'    		=> $customize_default['show_categories'],
			'type'       		=> 'option',
			'sanitize_callback' => 'orbit_sanitize_checkbox'
		)
	);

	// [Basic] Section: Posts -- Control: show_categories
	$wp_customize->add_control(
		'show_categories',
		array(
			'label' 	=> __( 'Show Categories', 'orbit' ),
			'section' 	=> 'posts_section',
			'type' 		=> 'checkbox',
			'settings'  => 'orbit_theme_options[show_categories]',
		)
	);

	// [Basic] Section: Posts -- Setting: show_tags
	$wp_customize->add_setting(
		'orbit_theme_options[show_tags]',
		array(
			'default'  			=> $customize_default['show_tags'],
			'type'     			=> 'option',
			'sanitize_callback' => 'orbit_sanitize_checkbox'
		)
	);

	// [Basic] Section: Posts -- Control: show_tags
	$wp_customize->add_control(
		'show_tags',
		array(
			'label' 	=> __( 'Show Tags', 'orbit' ),
			'section' 	=> 'posts_section',
			'type' 		=> 'checkbox',
			'settings'  => 'orbit_theme_options[show_tags]',
		)
	);

	// Creating Section: Social Section
	$wp_customize->add_section(
		'social_section',
		array(
			'title'    => __( 'Social Options', 'orbit' ),
			'priority' => 23,
			'capability' => 'edit_theme_options',
	 	)
	 	);

	orbit_add_social_fields( $wp_customize, $customize_default );

	// Creating Section: Text Section
	$wp_customize->add_section(
		'text_section',
		array(
			'title'    => __( 'Font Options', 'orbit' ),
			'priority' => 24,
			'capability' => 'edit_theme_options',
	 	)
	 	);

	// [Basic] Section: Text -- Setting: orbit_font_title
	$wp_customize->add_setting(
		'orbit_theme_options[orbit_font_title]',
		array(
			'default'   		=> $customize_default['orbit_font_title'],
			'type'		        => 'option',
			'sanitize_callback' => 'orbit_sanitize_font_title'
		)
	);

	// [Basic] Section: Text -- Control: orbit_font_title
	$wp_customize->add_control(
		new Orbit_Font_Select_Control(
			$wp_customize,
			'orbit_theme_options[orbit_font_title]',
			array(
				'label'    => __( 'Headings Font Family', 'orbit' ),
			    'section' => 'text_section',
				'choices'  => orbit_font_choise(),
				'settings'  => 'orbit_theme_options[orbit_font_title]',
			)
		)
	);

	// [Basic] Section: Text -- Setting: google_font_title
	$wp_customize->add_setting(
		'orbit_theme_options[google_font_title]',
		array(
			'default'    		=> $customize_default['google_font_title'],
			'type'       		=> 'option',
			'sanitize_callback' => 'orbit_sanitize_text'
		)
	);

	// [Basic] Section: Text -- Control: google_font_title
	$wp_customize->add_control(
		'google_font_title',
		array(
			'label' 	  => __( 'Headings Google Font', 'orbit' ),
			'section' 	  => 'text_section',
			'type' 		  => 'text',
			'description' => sprintf( __( ' Ex: Marko One. Go to %s for some font inspiration.', 'orbit' ), "<a href='http://www.google.com/webfonts' target='_blank'> Google Fonts</a>" ),
			'settings'  => 'orbit_theme_options[google_font_title]',
		)
	);

	// [Basic] Section: Text -- Setting: orbit_font_base
	$wp_customize->add_setting(
		'orbit_theme_options[orbit_font_base]',
		array(
			'default'   		=> $customize_default['orbit_font_base'],
			'type'       		=> 'option',
			'sanitize_callback' => 'orbit_sanitize_font_base'
		)
	);

	// [Basic] Section: Text -- Control: orbit_font_base
	$wp_customize->add_control(
		new Orbit_Font_Select_Control(
			$wp_customize,
			'orbit_theme_options[orbit_font_base]',
			array(
				'label'    => __( 'Default Font Family', 'orbit' ),
			    'section' => 'text_section',
				'choices'  => orbit_font_choise(),
				'settings'  => 'orbit_theme_options[orbit_font_base]',
			)
		)
	);

	// [Basic] Section: Text -- Setting: google_font_base
	$wp_customize->add_setting(
		'orbit_theme_options[google_font_base]',
		array(
			'default'    		=> $customize_default['google_font_base'],
			'type'       		=> 'option',
			'sanitize_callback' => 'orbit_sanitize_text'
		)
	);

	// [Basic] Section: Text -- Control: google_font_base
	$wp_customize->add_control(
		'google_font_base',
		array(
			'label' 	  => __( 'Default Google Font', 'orbit' ),
			'section' 	  => 'text_section',
			'type' 		  => 'text',
			'description' => sprintf( __( ' Ex: Marko One. Go to %s for some font inspiration.', 'orbit' ), "<a href='http://www.google.com/webfonts' target='_blank'> Google Fonts</a>" ),
			'settings'  => 'orbit_theme_options[google_font_base]',
		)
	);

}
add_action( 'customize_register', 'orbit_customize_register_settings' );


/**
 * Add customize field for social fields
 *
 * @since Orbit 1.2.0
 */
function orbit_add_social_fields( $wp_customize, $customize_default ) {
	foreach ( orbit_get_social_theme_options() as $social => $social_text) {

		$wp_customize->add_setting(
			'orbit_theme_options[' . $social . ']',
			array(
				'default'    		=> $customize_default[$social],
				'type' 				=> 'option',
				'sanitize_callback' => 'orbit_sanitize_text'
			)
		);

		$wp_customize->add_control(
			$social,
			array(
				'label' 	  => $social_text,
				'section' 	  => 'social_section',
				'settings'    => 'orbit_theme_options[' . $social . ']',
			)
		);
	}
}
