/**
 * Theme options Javascript for Admin Panel
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */

/**
 * Show && hide sections panel admin
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
jQuery(document).ready(function($){

	$(".rwd-container").hide();

	// Recocer active sections from cookie
	var activeSections = [];
	activeSections = unescape($.cookie('activeSections')).split(',');
	for (var i = activeSections.length - 1; i >= 0; i--){
		$(activeSections[i]).toggleClass("active").next().slideToggle("fast");
	};
	$.removeCookie('activeSections');
	
	$("h3.rwd-toggle").click(function(){
		$(this).toggleClass("active").next().slideToggle("fast");
		return false; //Prevent the browser jump to the link anchor
	});
	
	// Save in cookie active sections
	$("#submit").click(function(){
		var activeSections = [];
		var elements = document.getElementsByClassName("rwd-toggle active");
		for (i=0;i<elements.length;i++){
			activeSections.push('#' + elements[i].id); 
		}
		$.cookie('activeSections', escape(activeSections.join(',')), {expires: 10 });
	});
	
});

/**
 * Show slowly box options panel admin
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
jQuery(document).ready(function($) {
	setTimeout(function () {
		$(".fade").fadeOut("slow", function () {
			$(".fade").remove();
		});

	}, 2000);
});

/**
 * Upload imagen button
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
jQuery(document).ready(function($) {

	jQuery('.upload_image_button').click(function() {
		inputurl = jQuery(this).prev('input');
		tbframe_interval = setInterval( function() {jQuery('#TB_iframeContent').contents().find('.savesend .button').val('Use This Image');}, 2000);
		tb_show('', 'media-upload.php?post_id=0&amp;type=file&amp;TB_iframe=true');
		return false;
	});

	window.send_to_editor = function(html) {
		imgurl = jQuery('img',html).attr('src');
		jQuery(inputurl).val(imgurl);
		tb_remove();

	}
});

/**
 * Picker color
 *
 * @package Orbit
 * @since Orbit 1.1.0
 */
jQuery(document).ready(function($) {

	var insertColor = function(colorPicker, input, linkexample) {
		$.farbtastic($(colorPicker), function(a) { $(input).val(a); $(linkexample).css('background', a); });
	};
	
	$('.pickcolor').click(function(e) {
		colorPicker = jQuery(this).next('div');
		input = jQuery(this).prev().prev('input');
		linkexample = jQuery(this).prev('span');

 		insertColor(colorPicker,input, linkexample);

		colorPicker.show();
		e.preventDefault();

		$(document).mousedown( function() { $(colorPicker).hide(); });
	});
	
	$('.color_default').click(function(e) {
		input = '#input_' + jQuery(this).attr('id');
		linkexample = '#example_' + jQuery(this).attr('id');
		colordefault = '#' + this.innerHTML.replace(/[^a-fA-F0-9]/, '');
		
		$(input).val(colordefault);
		$(linkexample).css('background', colordefault);
	});
	
});
