<?php
/**
 * Custom Control for Customizer Screen
 *
 * ========
 * Contents
 * ========
 *
 * - class Orbit_Select_Img_Control
 * - class Orbit_Font_Select_Control
 * - class Orbit_Customize_Logo_Control
 *
 * @package Orbit
 * @since Orbit 1.2.0
 */

/**
 * Class to create a layout select control
 *
 * @since Orbit 1.2.0
 */
class Orbit_Select_Img_Control extends WP_Customize_Control {

	/**
	 * Render the content on the theme customizer page
 	 *
     * @since Orbit 1.2.0
	 */
	public function render_content() {
		$name = '_customize-radio-' . $this->id;
		?>
		<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
		<?php foreach ( $this->choices as $value => $image ) : ?>
			<?php $class_selected = ( $this->value() == $value ) ? ' of-radio-img-selected' : ''; ?>
			<label>
				<input type="radio" value="<?php echo esc_attr( $value ); ?>" name="<?php echo esc_attr( $name ); ?>" <?php $this->link(); checked( $this->value(), $value ); ?> class="visuallyhidden" />
				<img src="<?php echo get_template_directory_uri() . esc_html( $image ); ?>" class="of-radio-img-img <?php echo $class_selected; ?>"/>
			</label>

		<?php endforeach;
	}

	/**
	 * Enqueue control related scripts/styles
 	 *
     * @since Orbit 1.2.0
	 */
	public function enqueue() {

		wp_enqueue_script( 'admin-customizer-control', get_template_directory_uri() . '/inc/js/admin-customizer-controls.js', array( 'jquery' ), null, true  );

		wp_enqueue_style( 'admin-customizer-control', get_template_directory_uri() . '/inc/css/admin-customizer-controls.css' );

	}
}


/**
 * Class to create a fonts select control
 *
 * @since Orbit 1.2.0
 */
class Orbit_Font_Select_Control extends WP_Customize_Control {

	/**
	 * Render the content on the theme customizer page
 	 *
     * @since Orbit 1.2.0
	 */
	public function render_content() {
		?>

		<label>
			<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
			<select <?php $this->link(); ?>>
				<optgroup label="<?php _e( 'San Serif Fonts', 'orbit' ); ?>">
					<?php
					foreach ( $this->choices['sans-serif'] as $value => $label )
						echo '<option value="' . esc_attr( $value ) . '"' . selected( $this->value(), $value, false ) . '>' . $label . '</option>';
					?>
				</optgroup>
				<optgroup label="<?php _e( 'Serif Fonts', 'orbit' ); ?>">
					<?php
					foreach ( $this->choices['serif'] as $value => $label )
						echo '<option value="' . esc_attr( $value ) . '"' . selected( $this->value(), $value, false ) . '>' . $label . '</option>';
					?>
				</optgroup>
			</select>
		</label>

		<?php
	}
}


/**
 * Customize Logo Control Class. It's a WP_Customize_Image_Control class
 * with 'description' field.
 *
 * @since Orbit 1.2.0
 */
class Orbit_Customize_Logo_Control extends WP_Customize_Image_Control {

	public $description;

	/**
	 * Render the control's content.
	 *
	 * @since Orbit 1.2.0
	 */
	public function render_content() {
		$src = $this->value();
		if ( isset( $this->get_url ) )
			$src = call_user_func( $this->get_url, $src );

		?>
		<div class="customize-image-picker">
			<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>

			<div class="customize-control-content">
				<div class="dropdown preview-thumbnail" tabindex="0">
					<div class="dropdown-content">
						<?php if ( empty( $src ) ): ?>
							<img style="display:none;" />
						<?php else: ?>
							<img src="<?php echo esc_url( set_url_scheme( $src ) ); ?>" />
						<?php endif; ?>
						<div class="dropdown-status"></div>
					</div>
					<div class="dropdown-arrow"></div>
				</div>
			</div>

			<div class="library">
				<ul>
					<?php foreach ( $this->tabs as $id => $tab ): ?>
						<li data-customize-tab='<?php echo esc_attr( $id ); ?>' tabindex='0'>
							<?php echo esc_html( $tab['label'] ); ?>
						</li>
					<?php endforeach; ?>
				</ul>
				<?php foreach ( $this->tabs as $id => $tab ): ?>
					<div class="library-content" data-customize-tab='<?php echo esc_attr( $id ); ?>'>
						<?php call_user_func( $tab['callback'] ); ?>
					</div>
				<?php endforeach; ?>
			</div>

			<div class="actions">
				<a href="#" class="remove"><?php _e( 'Remove Image', 'orbit' ); ?></a>
			</div>

			<?php if ( ! empty( $this->description ) ): ?>
				<div class="logo-description-control">
					<?php foreach ( $this->description as $key => $desc ): ?>
						<p class="description"><?php echo $desc; ?></p>
					<?php endforeach ?>
				</div>
			<?php endif ?>
		</div>
		<?php
	}

	/**
	 * Enqueue control related scripts/styles
 	 *
     * @since Orbit 1.2.0
	 */
	public function enqueue() {

		parent::enqueue();
		wp_enqueue_style( 'admin-customizer-control', get_template_directory_uri() . '/inc/css/admin-customizer-controls.css' );

	}

}

/**
 * Customize Textarea Control Class.
 *
 * @since Orbit 1.2.0
 */
class Orbit_Textarea_Control extends WP_Customize_Control {
	public $type = 'textarea';
 
	/**
	 * Render the control's content.
	 *
	 * @since Orbit 1.2.0
	 */
	public function render_content() {
	?>
		<label>
			<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
			<textarea rows="3" style="width:100%;" <?php $this->link(); ?>><?php echo esc_textarea( $this->value() ); ?></textarea>
		</label>
	<?php
	}
}