<?php
/**
 * The template for displaying image attachments.
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
?>

	<?php get_header(); ?>

	<div id="content-full">

		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<header class="article-header">
					<h1><a href="<?php esc_url( the_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( the_title_attribute( 'echo=0' ) ); ?>"><?php the_title(); ?></a></h1>
				</header>
				<a href="<?php echo esc_url( wp_get_attachment_url($post->ID) ); ?>"><?php echo wp_get_attachment_image( $post->ID, 'large' ); ?></a>
				<?php if ( !empty( $post->post_excerpt ) ) the_excerpt(); ?>
				<div class="navigation">
					<div class="previous"><?php previous_image_link( 'thumbnail' ); ?></div>
					<div class="next"><?php next_image_link( 'thumbnail' ); ?></div>
				</div><!-- end of .navigation -->
			</article>

		<?php endwhile; else : ?>

			<article>
				<h1><?php _e( 'Oops, Post Not Found!', 'orbit' ); ?></h1>
			</article>

		<?php endif; ?>

	</div>	<!-- end content -->

	<?php get_footer(); ?>