<?php
/**
 * The Header for Orbit.
 *
 * Displays all of the <head> section, breadcrumb, sidebar in left position
 * and everything up till <div id="content-container">
 *
 * @package Orbit
 * @since Orbit 1.0.0
 */
?>

<!DOCTYPE HTML>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<?php if ( ! function_exists( '_wp_render_title_tag' ) ) : ?>
		<title><?php wp_title( '|', true, 'right' ); ?></title>
	<?php endif; ?>
	<meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<!--[if ie]><meta content='IE=8' http-equiv='X-UA-Compatible'/><![endif]-->
	<!--[if lt IE 9]>
		<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php bit_main_container(); // after opening body hook ?>

<div id="main-container">
	<?php bit_header(); // after opening main-container hook ?>
	<?php $breadcrumb = orbit_get_theme_options( 'breadcrumb' ); ?>
	<header id="top-header" <?php if ( ! $breadcrumb && !is_front_page() ) { echo 'class="top-header-without-breadcrumb"'; } ?>>
		<?php bit_in_header(); // after opening top-header hook ?>

		<div id="logo">
			<?php if ( !get_header_image() ) : ?>
				<div class="site-name"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></div>
			<?php else: ?>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php header_image(); ?>" width="<?php echo get_custom_header() -> width; ?>" height="<?php echo get_custom_header() -> height; ?>" alt="<?php bloginfo( 'name' ); echo ' logo'; ?>"/></a>
			<?php endif; ?>
		</div><!-- end of #logo -->
		<div id="main-navigation">
			<?php orbit_render_social_items(); ?>
			<?php if ( has_nav_menu( 'header-menu' ) ) : ?>
		        <div class="menu-link">
		        	<a href="#" >Menu</a>
		        </div>
				<nav class="header-menu-nav" id="header-menu-nav">
					<?php wp_nav_menu( array( 'theme_location' => 'header-menu', 'container' => false, 'walker' => new Walker_Orbit_Nav_Menu ) ); ?>
				</nav>
			<?php endif; ?>
		</div>

	</header><!-- end of top-header -->
	<?php bit_header_end(); // after closing header hook ?>

	<?php if ( $breadcrumb ) orbit_render_breadcrumb();?>

	<?php bit_content_container(); // before opening 'content-container' hook ?>

	<div id="content-container">

	<?php bit_in_content_container(); // after closing 'content-container' hook ?>